/*! SignatureFieldExtension - v1.0.0 - 2018-01-14
* Copyright (c) 2018 Max Schuster; Licensed Apache-2.0 */

function eu_maxschuster_vaadin_signaturefield_SignatureFieldExtension(){"use strict";var a,b="image/png";this.init=function(){var c=this.getState();this.parent=this.findAndExtendParent(),this.canvas=this.createCanvas(this.parent),this.clearButton=null,this.signature=null,this.mimeType=b,this.signaturePad=this.createSignaturePad(this.canvas),a=this.signaturePad.dotSize,this.immediate=c.immediate,this.readOnly=c.readOnly,this.addResizeListener(this.parent,this.proxy(this.onResize))},this.proxy=function(a,b,c){return b=b||this,function(){a.apply(b,c||arguments)}},this.setSignature=function(a){var b=this.signaturePad;a!==this.signature&&(this.signature=a,a?b.fromDataURL(a):b.clear())},this.findAndExtendParent=function(){var a=this.getElement(this.getParentId());return a.tabIndex=-1,this.addEvent(a,"focus",this.proxy(this.onFocus)),this.addEvent(a,"blur",this.proxy(this.onBlur)),a},this.createCanvas=function(a){var b=document.createElement("canvas");return a.appendChild(b),b},this.updateCanvasSize=function(){var a=this.getComputedStyle(this.parent),b=this.canvas,c=this.signature,d=this.signaturePad,e=parseInt(a.width),f=parseInt(a.height);b.width=e,b.height=f,c?d.fromDataURL(c):d.clear()},this.createSignaturePad=function(a){var b=new SignaturePad(a);return b.onBegin=this.proxy(this.onStrokeBegin),b.onEnd=this.proxy(this.onStrokeEnd),b.vReadOnly=!1,b.fromDataURL=function(c){var d=new Image;d.src=c,d.onload=function(){b.clear(),this._isEmpty=!1,b._ctx.drawImage(d,0,0,a.width,a.height)},this._isEmpty=!1},b},this.createClearButton=function(a){var b=document.createElement("button");return b.setAttribute("class","signaturefield-clearbutton"),a.appendChild(b),this.addEvent(b,"click",this.proxy(this.onClearButtonClick)),b},this.onResize=function(){this.updateCanvasSize()},this.onStrokeBegin=function(){this.parent.focus()},this.onStrokeEnd=function(){this.immediate&&this.updateSignature()},this.onFocus=function(){this.addClass(this.parent,"v-focus")},this.onBlur=function(){this.updateSignature(),this.removeClass(this.parent,"v-focus")},this.onClearButtonClick=function(){this.clear()},this.onStateChange=function(){var c=this.getState(),d=this.parent,e=this.signaturePad;e.dotSize=c.dotSize||0===c.dotSize?c.dotSize:a,e.minWidth=c.minWidth,e.maxWidth=c.maxWidth,e.backgroundColor=c.backgroundColor,e.penColor=c.penColor,e.velocityFilterWeight=c.velocityFilterWeight,this.mimeType=c.mimeType||b,this.immediate=c.immediate;var f=c.readOnly,g=e.vReadOnly;f&&!g?(e.off(),d.removeAttribute("tabindex")):!f&&g&&(e.on(),d.tabIndex=-1),e.vReadOnly=f,f||!c.clearButtonEnabled||this.clearButton?!f&&c.clearButtonEnabled||!this.clearButton||(d.removeChild(this.clearButton),this.clearButton=null):this.clearButton=this.createClearButton(d)},this.getComputedStyle=function(a){return window.getComputedStyle?window.getComputedStyle(a):a.currentStyle},this.getCurrentSignature=function(){var a=this.signaturePad;return a.isEmpty()?null:a.toDataURL(this.mimeType,1)},this.updateSignature=function(a){var b=this.signature,c=arguments.length>0?a:this.getCurrentSignature();c!==b&&(this.signature=c,this.fireSignatureChange(c))},this.clear=function(){this.signaturePad.clear(),this.updateSignature(null)},this.addEvent=function(a,b,c){if(a.addEventListener)a.addEventListener(b,c,!1);else{if(!a.attachEvent)return b="on"+b,"function"==typeof a[b]&&(c=function(a,b){return function(){a.apply(this,arguments),b.apply(this,arguments)}}(a[b],c)),a[b]=c,!0;a.attachEvent("on"+b,c)}return!1},this.addClass=function(a,b){for(var c=(a.getAttribute("class")||"").split(" "),d=0;d<c.length;d++){if(c[d]===b)return}c.push(b),a.setAttribute("class",c.join(" "))},this.removeClass=function(a,b){for(var c=(a.getAttribute("class")||"").split(" "),d=c.length,e=0;e<d;e++){c[e]===b&&(c.splice(e,1),d--,e--)}a.setAttribute("class",c.join(" "))},this.init()}!function(a,b){"function"==typeof define&&define.amd?define([],function(){return a.SignaturePad=b()}):"object"==typeof exports?module.exports=b():a.SignaturePad=b()}(this,function(){return function(a){"use strict";var b=function(a,b){var c=this,d=b||{};this.velocityFilterWeight=d.velocityFilterWeight||.7,this.minWidth=d.minWidth||.5,this.maxWidth=d.maxWidth||2.5,this.dotSize=d.dotSize||function(){return(this.minWidth+this.maxWidth)/2},this.penColor=d.penColor||"black",this.backgroundColor=d.backgroundColor||"rgba(0,0,0,0)",this.onEnd=d.onEnd,this.onBegin=d.onBegin,this._canvas=a,this._ctx=a.getContext("2d"),this.clear(),this._handleMouseDown=function(a){1===a.which&&(c._mouseButtonDown=!0,c._strokeBegin(a))},this._handleMouseMove=function(a){c._mouseButtonDown&&c._strokeUpdate(a)},this._handleMouseUp=function(a){1===a.which&&c._mouseButtonDown&&(c._mouseButtonDown=!1,c._strokeEnd(a))},this._handleTouchStart=function(a){if(1==a.targetTouches.length){var b=a.changedTouches[0];c._strokeBegin(b)}},this._handleTouchMove=function(a){a.preventDefault();var b=a.targetTouches[0];c._strokeUpdate(b)},this._handleTouchEnd=function(a){a.target===c._canvas&&(a.preventDefault(),c._strokeEnd(a))},this._handleMouseEvents(),this._handleTouchEvents()};b.prototype.clear=function(){var a=this._ctx,b=this._canvas;a.fillStyle=this.backgroundColor,a.clearRect(0,0,b.width,b.height),a.fillRect(0,0,b.width,b.height),this._reset()},b.prototype.toDataURL=function(a,b){var c=this._canvas;return c.toDataURL.apply(c,arguments)},b.prototype.fromDataURL=function(a){var b=this,c=new Image,d=window.devicePixelRatio||1,e=this._canvas.width/d,f=this._canvas.height/d;this._reset(),c.src=a,c.onload=function(){b._ctx.drawImage(c,0,0,e,f)},this._isEmpty=!1},b.prototype._strokeUpdate=function(a){var b=this._createPoint(a);this._addPoint(b)},b.prototype._strokeBegin=function(a){this._reset(),this._strokeUpdate(a),"function"==typeof this.onBegin&&this.onBegin(a)},b.prototype._strokeDraw=function(a){var b=this._ctx,c="function"==typeof this.dotSize?this.dotSize():this.dotSize;b.beginPath(),this._drawPoint(a.x,a.y,c),b.closePath(),b.fill()},b.prototype._strokeEnd=function(a){var b=this.points.length>2,c=this.points[0];!b&&c&&this._strokeDraw(c),"function"==typeof this.onEnd&&this.onEnd(a)},b.prototype._handleMouseEvents=function(){this._mouseButtonDown=!1,this._canvas.addEventListener("mousedown",this._handleMouseDown),this._canvas.addEventListener("mousemove",this._handleMouseMove),a.addEventListener("mouseup",this._handleMouseUp)},b.prototype._handleTouchEvents=function(){this._canvas.style.msTouchAction="none",this._canvas.style.touchAction="none",this._canvas.addEventListener("touchstart",this._handleTouchStart),this._canvas.addEventListener("touchmove",this._handleTouchMove),this._canvas.addEventListener("touchend",this._handleTouchEnd)},b.prototype.on=function(){this._handleMouseEvents(),this._handleTouchEvents()},b.prototype.off=function(){this._canvas.removeEventListener("mousedown",this._handleMouseDown),this._canvas.removeEventListener("mousemove",this._handleMouseMove),a.removeEventListener("mouseup",this._handleMouseUp),this._canvas.removeEventListener("touchstart",this._handleTouchStart),this._canvas.removeEventListener("touchmove",this._handleTouchMove),this._canvas.removeEventListener("touchend",this._handleTouchEnd)},b.prototype.isEmpty=function(){return this._isEmpty},b.prototype._reset=function(){this.points=[],this._lastVelocity=0,this._lastWidth=(this.minWidth+this.maxWidth)/2,this._isEmpty=!0,this._ctx.fillStyle=this.penColor},b.prototype._createPoint=function(a){var b=this._canvas.getBoundingClientRect();return new c(a.clientX-b.left,a.clientY-b.top)},b.prototype._addPoint=function(a){var b,c,e,f,g=this.points;g.push(a),g.length>2&&(3===g.length&&g.unshift(g[0]),f=this._calculateCurveControlPoints(g[0],g[1],g[2]),b=f.c2,f=this._calculateCurveControlPoints(g[1],g[2],g[3]),c=f.c1,e=new d(g[1],b,c,g[2]),this._addCurve(e),g.shift())},b.prototype._calculateCurveControlPoints=function(a,b,d){var e=a.x-b.x,f=a.y-b.y,g=b.x-d.x,h=b.y-d.y,i={x:(a.x+b.x)/2,y:(a.y+b.y)/2},j={x:(b.x+d.x)/2,y:(b.y+d.y)/2},k=Math.sqrt(e*e+f*f),l=Math.sqrt(g*g+h*h),m=i.x-j.x,n=i.y-j.y,o=l/(k+l),p={x:j.x+m*o,y:j.y+n*o},q=b.x-p.x,r=b.y-p.y;return{c1:new c(i.x+q,i.y+r),c2:new c(j.x+q,j.y+r)}},b.prototype._addCurve=function(a){var b,c,d=a.startPoint,e=a.endPoint;b=e.velocityFrom(d),b=this.velocityFilterWeight*b+(1-this.velocityFilterWeight)*this._lastVelocity,c=this._strokeWidth(b),this._drawCurve(a,this._lastWidth,c),this._lastVelocity=b,this._lastWidth=c},b.prototype._drawPoint=function(a,b,c){var d=this._ctx;d.moveTo(a,b),d.arc(a,b,c,0,2*Math.PI,!1),this._isEmpty=!1},b.prototype._drawCurve=function(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o=this._ctx,p=c-b;for(d=Math.floor(a.length()),o.beginPath(),f=0;f<d;f++)g=f/d,h=g*g,i=h*g,j=1-g,k=j*j,l=k*j,m=l*a.startPoint.x,m+=3*k*g*a.control1.x,m+=3*j*h*a.control2.x,m+=i*a.endPoint.x,n=l*a.startPoint.y,n+=3*k*g*a.control1.y,n+=3*j*h*a.control2.y,n+=i*a.endPoint.y,e=b+i*p,this._drawPoint(m,n,e);o.closePath(),o.fill()},b.prototype._strokeWidth=function(a){return Math.max(this.maxWidth/(a+1),this.minWidth)};var c=function(a,b,c){this.x=a,this.y=b,this.time=c||(new Date).getTime()};c.prototype.velocityFrom=function(a){return this.time!==a.time?this.distanceTo(a)/(this.time-a.time):1},c.prototype.distanceTo=function(a){return Math.sqrt(Math.pow(this.x-a.x,2)+Math.pow(this.y-a.y,2))};var d=function(a,b,c,d){this.startPoint=a,this.control1=b,this.control2=c,this.endPoint=d};return d.prototype.length=function(){var a,b,c,d,e,f,g,h,i=10,j=0;for(a=0;a<=i;a++)b=a/i,c=this._point(b,this.startPoint.x,this.control1.x,this.control2.x,this.endPoint.x),d=this._point(b,this.startPoint.y,this.control1.y,this.control2.y,this.endPoint.y),a>0&&(g=c-e,h=d-f,j+=Math.sqrt(g*g+h*h)),e=c,f=d;return j},d.prototype._point=function(a,b,c,d,e){return b*(1-a)*(1-a)*(1-a)+3*c*(1-a)*(1-a)*a+3*d*(1-a)*a*a+e*a*a*a},b}(document)});
//# sourceMappingURL=SignatureFieldExtension.min.js.map