/*
 * Copyright 2014 Max.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package eu.maxschuster.vaadin.signaturefield;

/**
 * Contains some predefined colors for {@link SignatureField}
 * 
 * @author Max Schuster
 */
public class SampleColors {
    
    /**
     * The color white
     */
    public static final String WHITE = "#fff";
    
    /**
     * The color black
     */
    public static final String BLACK = "#000";
    
    /**
     * The color white with full transparency
     */
    public static final String WHITE_TRANSPARENT = "rgba(255,255,255,0)";
    
    /**
     * The color black with full transparency
     */
    public static final String BLACK_TRANSPARENT = "rgba(0,0,0,0)";
    
    /**
     * The color ultramarine
     * 
     * @see <a href="http://en.wikipedia.org/wiki/Ultramarine">Ultramarine</a>
     */
    public static final String ULTRAMARINE = "#120a8f";
    
}
