/*
 * Decompiled with CFR 0.152.
 */
package eu.miaplatform.decorators.predecorators;

import eu.miaplatform.decorators.DecoratorRequest;
import eu.miaplatform.decorators.predecorators.PreDecoratorRequest;
import java.io.Serializable;
import java.util.Map;

public class PreDecoratorRequestProxy {
    private PreDecoratorRequestProxy() {
    }

    public static class Builder {
        private final DecoratorRequest request;

        public Builder(DecoratorRequest originalRequest) {
            this.request = originalRequest;
        }

        public Builder setMethod(String method) {
            this.request.setMethod(method);
            return this;
        }

        public Builder setPath(String path) {
            this.request.setPath(path);
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.request.setHeaders(headers);
            return this;
        }

        public Builder setQuery(Map<String, String> query) {
            this.request.setQuery(query);
            return this;
        }

        public Builder setBody(Serializable body) {
            this.request.setBody(body);
            return this;
        }

        public PreDecoratorRequest build() {
            return PreDecoratorRequest.builder().method(this.request.getMethod()).path(this.request.getPath()).headers(this.request.getHeaders()).query(this.request.getQuery()).body(this.request.getBody()).build();
        }
    }
}

