/*
 * Decompiled with CFR 0.152.
 */
package eu.miaplatform.customplugin.springboot;

import eu.miaplatform.customplugin.springboot.Options;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

class Utils {
    Utils() {
    }

    static String getUserId(Options options, Map<String, String> headers) {
        return headers.get(options.getUserIdHeaderKey());
    }

    static List<String> getGroups(Options options, Map<String, String> headers) {
        String header = headers.get(options.getGroupsHeaderKey());
        String[] groupHeaders = header != null ? header.split(",") : new String[]{};
        return Arrays.stream(groupHeaders).filter(s -> s.length() > 0).collect(Collectors.toList());
    }

    static String getClientType(Options options, Map<String, String> headers) {
        return headers.get(options.getClientTypeHeaderKey());
    }

    static boolean isFromBackOffice(Options options, Map<String, String> headers) {
        String header = headers.get(options.getBackofficeHeaderKey());
        return header != null ? header.length() > 0 : false;
    }

    static Map<String, String> getHeadersInfo(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            map.put(key, value);
        }
        return map;
    }
}

