/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.springframework.boot.autoconfigure;

import ac.simons.neo4j.migrations.core.Discoverer;
import ac.simons.neo4j.migrations.core.JavaBasedMigration;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import ac.simons.neo4j.migrations.core.MigrationsException;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;

final class ApplicationContextAwareDiscoverer
implements Discoverer<JavaBasedMigration> {
    private final ObjectProvider<JavaBasedMigration> javaBasedMigrations;

    ApplicationContextAwareDiscoverer(ObjectProvider<JavaBasedMigration> javaBasedMigrations) {
        this.javaBasedMigrations = javaBasedMigrations;
    }

    public Collection<JavaBasedMigration> discover(MigrationContext context) {
        MigrationsConfig config = context.getConfig();
        ArrayList result = new ArrayList();
        this.javaBasedMigrations.forEach(result::add);
        Set loadedClasses = result.stream().map(JavaBasedMigration::getClass).collect(Collectors.toSet());
        if (config.getPackagesToScan().length != 0) {
            try (ScanResult scanResult = new ClassGraph().enableAllInfo().acceptPackages(config.getPackagesToScan()).enableExternalClasses().scan();){
                scanResult.getClassesImplementing(JavaBasedMigration.class.getName()).loadClasses(JavaBasedMigration.class).stream().filter(c -> !Modifier.isAbstract(c.getModifiers()) && !loadedClasses.contains(c)).map(c -> {
                    try {
                        return (JavaBasedMigration)JavaBasedMigration.getDefaultConstructorFor((Class)c).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new MigrationsException("Could not instantiate migration " + c.getName(), (Throwable)e);
                    }
                }).forEach(result::add);
            }
        }
        return List.copyOf(result);
    }
}

