/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.springframework.boot.autoconfigure;

import ac.simons.neo4j.migrations.core.Discoverer;
import ac.simons.neo4j.migrations.core.JavaBasedMigration;
import ac.simons.neo4j.migrations.core.Migrations;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import ac.simons.neo4j.migrations.core.MigrationsException;
import ac.simons.neo4j.migrations.springframework.boot.autoconfigure.ApplicationContextAwareDiscoverer;
import ac.simons.neo4j.migrations.springframework.boot.autoconfigure.ConfigBuilderCustomizer;
import ac.simons.neo4j.migrations.springframework.boot.autoconfigure.MigrationsInitializer;
import ac.simons.neo4j.migrations.springframework.boot.autoconfigure.MigrationsProperties;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.Driver;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jDataAutoConfiguration;
import org.springframework.boot.autoconfigure.neo4j.Neo4jAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@AutoConfiguration
@ConditionalOnClass(value={Migrations.class})
@ConditionalOnBean(value={Driver.class})
@AutoConfigureAfter(value={Neo4jAutoConfiguration.class})
@AutoConfigureBefore(value={Neo4jDataAutoConfiguration.class})
@EnableConfigurationProperties(value={MigrationsProperties.class})
public class MigrationsAutoConfiguration {
    private static final Log LOG = LogFactory.getLog(MigrationsAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={MigrationsConfig.class, Migrations.class, MigrationsInitializer.class})
    MigrationsConfig neo4jMigrationsConfig(ResourceLoader resourceLoader, MigrationsProperties migrationsProperties, ObjectProvider<ConfigBuilderCustomizer> configBuilderCustomizers, ObjectProvider<Discoverer<JavaBasedMigration>> applicationContextAwareDiscoverer) {
        if (migrationsProperties.isCheckLocation()) {
            MigrationsAutoConfiguration.checkLocationExists(resourceLoader, migrationsProperties);
        }
        MigrationsConfig.Builder builder = MigrationsConfig.builder().withLocationsToScan(migrationsProperties.getLocationsToScan()).withPackagesToScan(migrationsProperties.getPackagesToScan()).withTransactionMode(migrationsProperties.getTransactionMode()).withTransactionTimeout(migrationsProperties.getTransactionTimeout()).withDatabase(migrationsProperties.getDatabase()).withSchemaDatabase(migrationsProperties.getSchemaDatabase()).withImpersonatedUser(migrationsProperties.getImpersonatedUser()).withInstalledBy(migrationsProperties.getInstalledBy()).withValidateOnMigrate(migrationsProperties.isValidateOnMigrate()).withAutocrlf(migrationsProperties.isAutocrlf()).withDelayBetweenMigrations(migrationsProperties.getDelayBetweenMigrations()).withVersionSortOrder(migrationsProperties.getVersionSortOrder()).withMigrationClassesDiscoverer((Discoverer)applicationContextAwareDiscoverer.getIfAvailable()).withOutOfOrderAllowed(migrationsProperties.isOutOfOrder()).withFlywayCompatibleChecksums(migrationsProperties.isUseFlywayCompatibleChecksums()).withTarget(migrationsProperties.getTarget());
        configBuilderCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean(value={Migrations.class, MigrationsInitializer.class})
    Migrations neo4jMigrations(MigrationsConfig neo4jMigrationsConfig, Driver driver) {
        return new Migrations(neo4jMigrationsConfig, driver);
    }

    @Bean
    @ConditionalOnMissingBean(value={MigrationsInitializer.class})
    @ConditionalOnProperty(prefix="org.neo4j.migrations", name={"enabled"}, matchIfMissing=true)
    MigrationsInitializer neo4jMigrationsInitializer(Migrations neo4jMigrations) {
        return new MigrationsInitializer(neo4jMigrations);
    }

    @Bean
    @ConditionalOnMissingBean(value={Discoverer.class})
    @ConditionalOnProperty(prefix="org.neo4j.migrations", name={"enabled"}, matchIfMissing=true)
    Discoverer<JavaBasedMigration> applicationContextAwareDiscoverer(ObjectProvider<JavaBasedMigration> javaBasedMigrations) {
        return new ApplicationContextAwareDiscoverer(javaBasedMigrations);
    }

    private static void checkLocationExists(ResourceLoader resourceLoader, MigrationsProperties properties) {
        if (properties.getLocationsToScan().length == 0 && properties.getPackagesToScan().length == 0) {
            throw new MigrationsException("Neither locations nor packages to scan are configured.");
        }
        if (properties.getPackagesToScan().length == 0 && !MigrationsAutoConfiguration.hasAtLeastOneLocation(resourceLoader, properties.getLocationsToScan())) {
            LOG.warn((Object)"No package to scan is configured and none of the configured locations exists.");
        }
    }

    private static boolean hasAtLeastOneLocation(ResourceLoader resourceLoader, String[] locations) {
        return Arrays.stream(locations).map(arg_0 -> ((ResourceLoader)resourceLoader).getResource(arg_0)).anyMatch(Resource::exists);
    }
}

