/*
 * Copyright 2020-2023 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ac.simons.neo4j.migrations.springframework.boot.autoconfigure;

import ac.simons.neo4j.migrations.core.Migrations;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.springframework.beans.factory.InitializingBean;

/**
 * {@link InitializingBean} used to trigger a {@link ac.simons.neo4j.migrations.core.Migrations Neo4j migration}.
 *
 * @author Michael J. Simons
 * @since 0.0.6
 */
final class MigrationsInitializer implements InitializingBean {

	private static final Log LOG = LogFactory.getLog(MigrationsInitializer.class);

	private final Migrations migrations;

	MigrationsInitializer(Migrations migrations) {
		this.migrations = migrations;
	}

	@Override
	public void afterPropertiesSet() {

		try {
			migrations.apply(true);
		} catch (ServiceUnavailableException e) {
			LOG.error("Cannot apply Neo4j migrations, driver instance cannot reach any database.", e);
		}
	}
}
