/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.Migration;
import ac.simons.neo4j.migrations.core.MigrationChain;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationState;
import ac.simons.neo4j.migrations.core.MigrationType;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import ac.simons.neo4j.migrations.core.Migrations;
import ac.simons.neo4j.migrations.core.MigrationsException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.summary.DatabaseInfo;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.ServerInfo;
import org.neo4j.driver.types.IsoDuration;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;

final class ChainBuilder {
    ChainBuilder() {
    }

    MigrationChain buildChain(MigrationContext context, List<Migration> discoveredMigrations) {
        Map<MigrationVersion, MigrationChain.Element> elements = this.buildChain0(context, discoveredMigrations);
        try (Session session = context.getSession();){
            class ExtendedResultSummary {
                final boolean showCurrentUserExists;
                final ServerVersion version;
                final ServerInfo server;
                final DatabaseInfo database;

                ExtendedResultSummary(boolean showCurrentUserExists, ServerVersion version, ResultSummary actualSummary) {
                    this.showCurrentUserExists = showCurrentUserExists;
                    this.version = version;
                    this.server = actualSummary.server();
                    this.database = actualSummary.database();
                }
            }
            ExtendedResultSummary databaseInformation = (ExtendedResultSummary)session.readTransaction(tx -> {
                Result result = tx.run("CALL dbms.procedures() YIELD name WHERE name = 'dbms.showCurrentUser' WITH count(*) > 0 AS showCurrentUserExists CALL dbms.components() YIELD versions RETURN showCurrentUserExists, 'Neo4j/' + versions[0] AS version");
                Record singleResultRecord = result.single();
                boolean showCurrentUserExists = singleResultRecord.get("showCurrentUserExists").asBoolean();
                ServerVersion version = ServerVersion.version((String)singleResultRecord.get("version").asString());
                ResultSummary summary = result.consume();
                return new ExtendedResultSummary(showCurrentUserExists, version, summary);
            });
            String username = "anonymous";
            if (databaseInformation.showCurrentUserExists) {
                username = (String)session.readTransaction(tx -> tx.run("CALL dbms.procedures() YIELD name WHERE name = 'dbms.showCurrentUser' CALL dbms.showCurrentUser() YIELD username RETURN username").single().get("username").asString());
            }
            ServerInfo serverInfo = databaseInformation.server;
            DatabaseInfo database = databaseInformation.database;
            DefaultMigrationChain defaultMigrationChain = new DefaultMigrationChain(serverInfo.address(), databaseInformation.version.toString(), username, database == null ? null : database.name(), elements);
            return defaultMigrationChain;
        }
    }

    private Map<MigrationVersion, MigrationChain.Element> buildChain0(MigrationContext context, List<Migration> discoveredMigrations) {
        Map<MigrationVersion, MigrationChain.Element> appliedMigrations = this.getChainOfAppliedMigrations(context);
        LinkedHashMap<MigrationVersion, MigrationChain.Element> fullMigrationChain = new LinkedHashMap<MigrationVersion, MigrationChain.Element>(discoveredMigrations.size() + appliedMigrations.size());
        if (discoveredMigrations.isEmpty()) {
            fullMigrationChain.putAll(appliedMigrations);
        } else {
            int i = 0;
            for (Map.Entry<MigrationVersion, MigrationChain.Element> entry : appliedMigrations.entrySet()) {
                MigrationVersion expectedVersion = entry.getKey();
                Optional<String> expectedChecksum = entry.getValue().getChecksum();
                Migration newMigration = discoveredMigrations.get(i);
                if (!newMigration.getVersion().equals(expectedVersion)) {
                    throw new MigrationsException("Unexpected migration at index " + i + ": " + Migrations.toString(newMigration));
                }
                if (context.getConfig().isValidateOnMigrate() && !expectedChecksum.equals(newMigration.getChecksum())) {
                    throw new MigrationsException("Checksum of " + Migrations.toString(newMigration) + " changed!");
                }
                fullMigrationChain.put(expectedVersion, entry.getValue());
                ++i;
            }
            while (i < discoveredMigrations.size()) {
                Migration pendingMigration = discoveredMigrations.get(i++);
                MigrationChain.Element element = DefaultChainElement.pendingElement(pendingMigration);
                fullMigrationChain.put(pendingMigration.getVersion(), element);
            }
        }
        return Collections.unmodifiableMap(fullMigrationChain);
    }

    private Map<MigrationVersion, MigrationChain.Element> getChainOfAppliedMigrations(MigrationContext context) {
        LinkedHashMap<MigrationVersion, MigrationChain.Element> chain = new LinkedHashMap<MigrationVersion, MigrationChain.Element>();
        try (Session session = context.getSession();){
            Result result = session.run("MATCH p=(b:__Neo4jMigration {version:'BASELINE'}) - [r:MIGRATED_TO*] -> (l:__Neo4jMigration) \nWHERE NOT (l)-[:MIGRATED_TO]->(:__Neo4jMigration)\nRETURN p");
            if (result.hasNext()) {
                result.single().get("p").asPath().forEach(segment -> {
                    MigrationChain.Element chainElement = DefaultChainElement.appliedElement(segment);
                    chain.put(MigrationVersion.withValue(chainElement.getVersion()), chainElement);
                });
            }
        }
        return chain;
    }

    private static class DefaultMigrationChain
    implements MigrationChain {
        private final String serverAdress;
        private final String serverVersion;
        private final String username;
        private final String databaseName;
        private final Map<MigrationVersion, MigrationChain.Element> elements;

        DefaultMigrationChain(String serverAdress, String serverVersion, String username, String databaseName, Map<MigrationVersion, MigrationChain.Element> elements) {
            this.serverAdress = serverAdress;
            this.serverVersion = serverVersion;
            this.username = username;
            this.databaseName = databaseName;
            this.elements = elements;
        }

        @Override
        public String getServerAddress() {
            return this.serverAdress;
        }

        @Override
        public String getServerVersion() {
            return this.serverVersion;
        }

        @Override
        public String getUsername() {
            return this.username;
        }

        @Override
        public String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public boolean isApplied(String version) {
            MigrationChain.Element element = this.elements.get(MigrationVersion.withValue(version));
            return element != null && element.getState() == MigrationState.APPLIED;
        }

        @Override
        public Collection<MigrationChain.Element> getElements() {
            return this.elements.values();
        }
    }

    private static class DefaultChainElement
    implements MigrationChain.Element {
        private final MigrationState state;
        private final MigrationType type;
        private final String checksum;
        private final String version;
        private final String description;
        private final String source;
        private final InstallationInfo installationInfo;

        static MigrationChain.Element appliedElement(Path.Segment appliedMigration) {
            Node targetMigration = appliedMigration.end();
            Map properties = targetMigration.asMap();
            Relationship migrationProperties = appliedMigration.relationship();
            ZonedDateTime installedOn = migrationProperties.get("at").asZonedDateTime();
            String installedBy = String.format("%s/%s", migrationProperties.get("by").asString(), migrationProperties.get("connectedAs").asString());
            IsoDuration storedExecutionTime = migrationProperties.get("in").asIsoDuration();
            Duration executionTime = Duration.ofSeconds(storedExecutionTime.seconds()).plusNanos(storedExecutionTime.nanoseconds());
            return new DefaultChainElement(MigrationState.APPLIED, MigrationType.valueOf((String)properties.get("type")), (String)properties.get("checksum"), (String)properties.get("version"), (String)properties.get("description"), (String)properties.get("source"), new InstallationInfo(installedOn, installedBy, executionTime));
        }

        static MigrationChain.Element pendingElement(Migration pendingMigration) {
            return new DefaultChainElement(MigrationState.PENDING, Migrations.getMigrationType(pendingMigration), pendingMigration.getChecksum().orElse(null), pendingMigration.getVersion().getValue(), pendingMigration.getDescription(), pendingMigration.getSource(), null);
        }

        private DefaultChainElement(MigrationState state, MigrationType type, String checksum, String version, String description, String source, InstallationInfo installationInfo) {
            this.state = state;
            this.type = type;
            this.checksum = checksum;
            this.version = version;
            this.description = description;
            this.source = source;
            this.installationInfo = installationInfo;
        }

        @Override
        public MigrationState getState() {
            return this.state;
        }

        @Override
        public MigrationType getType() {
            return this.type;
        }

        @Override
        public Optional<String> getChecksum() {
            return Optional.ofNullable(this.checksum);
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getSource() {
            return this.source;
        }

        @Override
        public Optional<ZonedDateTime> getInstalledOn() {
            return Optional.ofNullable(this.installationInfo).map(InstallationInfo::getInstalledOn);
        }

        @Override
        public Optional<String> getInstalledBy() {
            return Optional.ofNullable(this.installationInfo).map(InstallationInfo::getInstalledBy);
        }

        @Override
        public Optional<Duration> getExecutionTime() {
            return Optional.ofNullable(this.installationInfo).map(InstallationInfo::getExecutionTime);
        }

        static class InstallationInfo {
            private final ZonedDateTime installedOn;
            private final String installedBy;
            private final Duration executionTime;

            InstallationInfo(ZonedDateTime installedOn, String installedBy, Duration executionTime) {
                this.installedOn = installedOn;
                this.installedBy = installedBy;
                this.executionTime = executionTime;
            }

            ZonedDateTime getInstalledOn() {
                return this.installedOn;
            }

            String getInstalledBy() {
                return this.installedBy;
            }

            Duration getExecutionTime() {
                return this.executionTime;
            }
        }
    }
}

