/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.Defaults;
import ac.simons.neo4j.migrations.core.Migration;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import ac.simons.neo4j.migrations.core.MigrationsException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import org.neo4j.driver.QueryRunner;
import org.neo4j.driver.Session;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.SummaryCounters;

final class CypherBasedMigration
implements Migration {
    private static final Logger LOGGER = Logger.getLogger(CypherBasedMigration.class.getName());
    private final URL url;
    private final String script;
    private final String description;
    private final MigrationVersion version;
    private final boolean autocrlf;
    private volatile List<String> statements;
    private volatile String checksum;

    CypherBasedMigration(URL url) {
        this(url, false);
    }

    CypherBasedMigration(URL url, boolean autocrlf) {
        this.url = url;
        String path = this.url.getPath();
        try {
            path = URLDecoder.decode(path, Defaults.CYPHER_SCRIPT_ENCODING.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new MigrationsException("Somethings broken: UTF-8 encoding not supported.");
        }
        int lastIndexOf = path.lastIndexOf("/");
        this.script = lastIndexOf < 0 ? path : path.substring(lastIndexOf + 1);
        this.version = MigrationVersion.parse(this.script);
        this.description = this.version.getDescription();
        this.autocrlf = autocrlf;
    }

    @Override
    public MigrationVersion getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getSource() {
        return this.script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> getChecksum() {
        String availableChecksum = this.checksum;
        if (availableChecksum == null) {
            CypherBasedMigration cypherBasedMigration = this;
            synchronized (cypherBasedMigration) {
                availableChecksum = this.checksum;
                if (availableChecksum == null) {
                    availableChecksum = this.checksum = this.computeChecksum();
                }
            }
        }
        return Optional.of(availableChecksum);
    }

    String computeChecksum() {
        CRC32 crc32 = new CRC32();
        for (String statement : this.getStatements()) {
            byte[] bytes = statement.getBytes(Defaults.CYPHER_SCRIPT_ENCODING);
            crc32.update(bytes, 0, bytes.length);
        }
        return Long.toString(crc32.getValue());
    }

    @Override
    public void apply(MigrationContext context) {
        try (Session session = context.getSession();){
            int numberOfStatements = 0;
            MigrationsConfig.TransactionMode transactionMode = context.getConfig().getTransactionMode();
            if (transactionMode == MigrationsConfig.TransactionMode.PER_MIGRATION) {
                LOGGER.log(Level.FINE, "Executing migration \"{0}\" in one transaction", this.getDescription());
                numberOfStatements = (Integer)session.writeTransaction(t -> {
                    int cnt = 0;
                    for (String statement : this.getStatements()) {
                        this.run((QueryRunner)t, statement);
                        ++cnt;
                    }
                    return cnt;
                });
            } else if (transactionMode == MigrationsConfig.TransactionMode.PER_STATEMENT) {
                LOGGER.log(Level.FINE, "Executing statements contained in migration \"{0}\" in seperate transactions", this.getDescription());
                for (String statement : this.getStatements()) {
                    numberOfStatements += ((Integer)session.writeTransaction(t -> {
                        this.run((QueryRunner)t, statement);
                        return 1;
                    })).intValue();
                }
            } else {
                throw new MigrationsException("Unknown transaction mode " + (Object)((Object)transactionMode));
            }
            LOGGER.log(Level.FINE, "Executed {0} statements", numberOfStatements);
        }
    }

    private void run(QueryRunner runner, String statement) {
        LOGGER.log(Level.FINE, "Running {0}", statement);
        ResultSummary resultSummary = runner.run(statement).consume();
        SummaryCounters c = resultSummary.counters();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "nodesCreated: {0}, nodesDeleted: {1}, relationshipsCreated: {2}, relationshipsDeleted: {3}, propertiesSet: {4}, labelsAdded: {5}, labelsRemoved: {6}, indexesAdded: {7}, indexesRemoved: {8}, constraintsAdded: {9}, constraintsRemoved: {10}", new Object[]{c.nodesCreated(), c.nodesDeleted(), c.relationshipsCreated(), c.relationshipsDeleted(), c.propertiesSet(), c.labelsAdded(), c.labelsRemoved(), c.indexesAdded(), c.indexesRemoved(), c.constraintsAdded(), c.constraintsRemoved()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getStatements() {
        List<String> availableStatements = this.statements;
        if (availableStatements == null) {
            CypherBasedMigration cypherBasedMigration = this;
            synchronized (cypherBasedMigration) {
                availableStatements = this.statements;
                if (availableStatements == null) {
                    availableStatements = this.statements = this.readStatements();
                }
            }
        }
        return availableStatements;
    }

    private List<String> readStatements() {
        ArrayList<String> newStatements = new ArrayList<String>();
        try (Scanner scanner = new Scanner(this.url.openStream(), Defaults.CYPHER_SCRIPT_ENCODING.name()).useDelimiter(";(:?\r?\n|\r)");){
            while (scanner.hasNext()) {
                String statement = scanner.next().trim().replaceAll(";$", "").trim();
                if (this.autocrlf) {
                    statement = statement.replace("\r\n", "\n");
                }
                if (statement.isEmpty()) continue;
                newStatements.add(statement);
            }
        }
        catch (IOException e) {
            throw new MigrationsException("Could not read script file " + this.url, e);
        }
        return Collections.unmodifiableList(newStatements);
    }

    public String toString() {
        return "CypherBasedMigration{url=" + this.url + ", script='" + this.script + '\'' + '}';
    }
}

