/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.CypherBasedMigration;
import ac.simons.neo4j.migrations.core.JavaBasedMigration;
import ac.simons.neo4j.migrations.core.Location;
import ac.simons.neo4j.migrations.core.Migration;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import ac.simons.neo4j.migrations.core.MigrationsException;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

interface Discoverer {
    public Collection<Migration> discoverMigrations(MigrationContext var1);

    public static class CypherBasedMigrationDiscoverer
    implements Discoverer {
        private static final Logger LOGGER = Logger.getLogger(CypherBasedMigrationDiscoverer.class.getName());

        @Override
        public Collection<Migration> discoverMigrations(MigrationContext context) {
            MigrationsConfig config = context.getConfig();
            ArrayList<Migration> listOfMigrations = new ArrayList<Migration>();
            ArrayList<String> classpathLocations = new ArrayList<String>();
            ArrayList<String> filesystemLocations = new ArrayList<String>();
            for (String prefixAndLocation : config.getLocationsToScan()) {
                Location location = Location.of(prefixAndLocation);
                if (location.getType() == Location.LocationType.CLASSPATH) {
                    classpathLocations.add(location.getName());
                    continue;
                }
                if (location.getType() != Location.LocationType.FILESYSTEM) continue;
                filesystemLocations.add(location.getName());
            }
            listOfMigrations.addAll(this.scanClasspathLocations(classpathLocations, context.getConfig()));
            listOfMigrations.addAll(this.scanFilesystemLocations(filesystemLocations, context.getConfig()));
            return listOfMigrations;
        }

        private List<Migration> scanClasspathLocations(List<String> classpathLocations, MigrationsConfig config) {
            if (classpathLocations.isEmpty()) {
                return Collections.emptyList();
            }
            LOGGER.log(Level.FINE, "Scanning for classpath resources in {0}", classpathLocations);
            String[] paths = classpathLocations.toArray(new String[0]);
            try (ScanResult scanResult = new ClassGraph().acceptPaths(paths).scan();){
                List<Migration> list = scanResult.getResourcesWithExtension("cypher").stream().map(resource -> new CypherBasedMigration(resource.getURL(), config.isAutocrlf())).collect(Collectors.toList());
                return list;
            }
        }

        private List<Migration> scanFilesystemLocations(List<String> filesystemLocations, final MigrationsConfig config) {
            if (filesystemLocations.isEmpty()) {
                return Collections.emptyList();
            }
            LOGGER.log(Level.FINE, "Scanning for filesystem resources in {0}", filesystemLocations);
            final ArrayList<Migration> migrations = new ArrayList<Migration>();
            for (String location : filesystemLocations) {
                Path path = Paths.get(location, new String[0]);
                try {
                    Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            if (attrs.isRegularFile() && file.getFileName().toString().endsWith(".cypher")) {
                                migrations.add(new CypherBasedMigration(file.toFile().toURI().toURL(), config.isAutocrlf()));
                                return FileVisitResult.CONTINUE;
                            }
                            return super.visitFile(file, attrs);
                        }
                    });
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return migrations;
        }
    }

    public static class JavaBasedMigrationDiscoverer
    implements Discoverer {
        @Override
        public Collection<Migration> discoverMigrations(MigrationContext context) {
            MigrationsConfig config = context.getConfig();
            if (config.getPackagesToScan().length == 0) {
                return Collections.emptyList();
            }
            try (ScanResult scanResult = new ClassGraph().enableAllInfo().acceptPackages(config.getPackagesToScan()).enableExternalClasses().scan();){
                Collection collection = scanResult.getClassesImplementing(JavaBasedMigration.class.getName()).loadClasses(Migration.class).stream().map(c -> {
                    try {
                        return JavaBasedMigrationDiscoverer.getConstructor(c).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new MigrationsException("Could not instantiate migration " + c.getName(), e);
                    }
                }).collect(Collectors.toList());
                return collection;
            }
        }

        private static Constructor<Migration> getConstructor(Class<Migration> c) throws NoSuchMethodException {
            Constructor<Migration> ctr = c.getDeclaredConstructor(new Class[0]);
            ctr.setAccessible(true);
            return ctr;
        }
    }
}

