/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.Discoverer;
import ac.simons.neo4j.migrations.core.Migration;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import ac.simons.neo4j.migrations.core.MigrationsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class DiscoveryService {
    private final List<Discoverer> discoverers = Collections.unmodifiableList(Arrays.asList(new Discoverer.JavaBasedMigrationDiscoverer(), new Discoverer.CypherBasedMigrationDiscoverer()));

    DiscoveryService() {
    }

    List<Migration> findMigrations(MigrationContext context) {
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        try {
            for (Discoverer discoverer : this.discoverers) {
                migrations.addAll(discoverer.discoverMigrations(context));
            }
        }
        catch (Exception e) {
            throw new MigrationsException("Unexpected error while scanning for migrations", e);
        }
        Collections.sort(migrations, Comparator.comparing(Migration::getVersion, new MigrationVersion.VersionComparator()));
        return Collections.unmodifiableList(migrations);
    }
}

