/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.MigrationsException;
import java.util.Locale;

final class Location {
    private final LocationType type;
    private final String name;

    static Location of(String prefixAndName) {
        int indexOfFirstColon = prefixAndName.indexOf(":");
        if (indexOfFirstColon < 0) {
            return new Location(LocationType.CLASSPATH, prefixAndName);
        }
        if (prefixAndName.length() < 3) {
            throw new MigrationsException("Invalid resource name: '" + prefixAndName + "'");
        }
        String prefix = prefixAndName.substring(0, indexOfFirstColon).toLowerCase(Locale.ENGLISH).trim();
        String name = prefixAndName.substring(indexOfFirstColon + 1).trim();
        if (name.length() == 0) {
            throw new MigrationsException("Invalid name.");
        }
        switch (prefix) {
            case "classpath": {
                return new Location(LocationType.CLASSPATH, name);
            }
            case "file": {
                return new Location(LocationType.FILESYSTEM, name);
            }
        }
        throw new MigrationsException("Invalid resource prefix: '" + prefix + "'");
    }

    private Location(LocationType type, String name) {
        this.type = type;
        this.name = name;
    }

    public LocationType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    static enum LocationType {
        CLASSPATH,
        FILESYSTEM;

    }
}

