/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.MigrationChainFormat;
import ac.simons.neo4j.migrations.core.MigrationState;
import ac.simons.neo4j.migrations.core.MigrationType;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Optional;

public interface MigrationChain {
    default public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append(MigrationChainFormat.LS).append("Database: ").append(this.getServerVersion() + "@").append(this.getServerAddress()).append(MigrationChainFormat.LS).append(MigrationChainFormat.LS);
        if (this.getElements().isEmpty()) {
            sb.append(MigrationChainFormat.LS).append("No migrations found.");
        } else {
            MigrationChainFormat.formatElements(this, sb);
        }
        return sb.toString();
    }

    public String getServerAddress();

    public String getServerVersion();

    public String getUsername();

    public String getDatabaseName();

    public boolean isApplied(String var1);

    public Collection<Element> getElements();

    public static interface Element {
        public MigrationState getState();

        public MigrationType getType();

        public Optional<String> getChecksum();

        public String getVersion();

        public String getDescription();

        public String getSource();

        public Optional<ZonedDateTime> getInstalledOn();

        public Optional<String> getInstalledBy();

        public Optional<Duration> getExecutionTime();
    }
}

