/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.MigrationChain;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

final class MigrationChainFormat {
    static final String LS = System.lineSeparator();

    static void formatElements(MigrationChain chain, StringBuilder target) {
        Map<String, List<String>> table = MigrationChainFormat.buildMigrationTable(chain);
        int[] columnWidths = new int[table.size()];
        int columnm = 0;
        for (Map.Entry<String, List<String>> entry : table.entrySet()) {
            String k2 = entry.getKey();
            List<String> v = entry.getValue();
            columnWidths[columnm++] = Math.max(k2.length(), v.stream().map(String::length).max(Integer::compareTo).orElse(0));
        }
        String[] columnFormats = (String[])Arrays.stream(columnWidths).mapToObj(w -> "| %-" + w + "s ").toArray(String[]::new);
        String separator = MigrationChainFormat.buildSeparator(columnWidths);
        TreeMap<Integer, StringBuilder> rows = new TreeMap<Integer, StringBuilder>();
        int numRows = chain.getElements().size();
        columnm = 0;
        for (List<String> v : table.values()) {
            for (int i = 0; i < numRows; ++i) {
                StringBuilder row2 = rows.computeIfAbsent(i, k -> new StringBuilder());
                row2.append(String.format(columnFormats[columnm], v.get(i)));
            }
            ++columnm;
        }
        target.append(separator);
        columnm = 0;
        for (String column : table.keySet()) {
            target.append(String.format(columnFormats[columnm++], column));
        }
        target.append("|").append(LS).append(separator);
        rows.values().forEach(row -> target.append((CharSequence)row).append("|").append(LS));
        target.append(separator);
    }

    private static Map<String, List<String>> buildMigrationTable(MigrationChain chain) {
        LinkedHashMap<String, List<String>> table = new LinkedHashMap<String, List<String>>();
        for (MigrationChain.Element element : chain.getElements()) {
            List column = table.computeIfAbsent("Version", k -> new ArrayList());
            column.add(element.getVersion());
            column = table.computeIfAbsent("Description", k -> new ArrayList());
            column.add(element.getDescription());
            column = table.computeIfAbsent("Type", k -> new ArrayList());
            column.add(element.getType().name());
            column = table.computeIfAbsent("Installed on", k -> new ArrayList());
            column.add(element.getInstalledOn().map(ZonedDateTime::toString).orElse(""));
            column = table.computeIfAbsent("by", k -> new ArrayList());
            column.add(element.getInstalledBy().orElse(""));
            column = table.computeIfAbsent("Execution time", k -> new ArrayList());
            column.add(element.getExecutionTime().map(Duration::toString).orElse(""));
            column = table.computeIfAbsent("State", k -> new ArrayList());
            column.add(element.getState().name());
            column = table.computeIfAbsent("Source", k -> new ArrayList());
            column.add(element.getSource());
        }
        return table;
    }

    private static String buildSeparator(int[] columnWidhts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < columnWidhts.length; ++i) {
            sb.append("+");
            for (int j = 0; j < columnWidhts[i] + 2; ++j) {
                sb.append("-");
            }
        }
        return sb.append("+").append(LS).toString();
    }

    private MigrationChainFormat() {
    }
}

