/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.MigrationsException;
import java.util.Comparator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MigrationVersion {
    private static final String BASELINE_VALUE = "BASELINE";
    private static final MigrationVersion BASELINE = new MigrationVersion("BASELINE", null);
    private static final Pattern VERSION_PATTERN = Pattern.compile("V(\\d+(?:_\\d+)*|\\d+(?:\\.\\d+)*)__([\\w ]+)(?:\\.cypher)?");
    private final String value;
    private final String description;

    static MigrationVersion of(Class<?> clazz) {
        return MigrationVersion.parse(clazz.getSimpleName());
    }

    static MigrationVersion parse(String simpleName) {
        Matcher matcher = VERSION_PATTERN.matcher(simpleName);
        if (!matcher.matches()) {
            throw new MigrationsException("Invalid class name for a migration: " + simpleName);
        }
        return new MigrationVersion(matcher.group(1).replace("_", "."), matcher.group(2).replace("_", " "));
    }

    static MigrationVersion withValue(String value) {
        return MigrationVersion.withValueAndDescription(value, null);
    }

    static MigrationVersion withValueAndDescription(String value, String description) {
        if (BASELINE_VALUE.equals(value)) {
            return MigrationVersion.baseline();
        }
        return new MigrationVersion(value, description);
    }

    static MigrationVersion baseline() {
        return BASELINE;
    }

    private MigrationVersion(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationVersion that = (MigrationVersion)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    static class VersionComparator
    implements Comparator<MigrationVersion> {
        VersionComparator() {
        }

        @Override
        public int compare(MigrationVersion o1, MigrationVersion o2) {
            if (o1 == MigrationVersion.baseline()) {
                return -1;
            }
            return o1.getValue().compareTo(o2.getValue());
        }
    }
}

