/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.ChainBuilder;
import ac.simons.neo4j.migrations.core.CypherBasedMigration;
import ac.simons.neo4j.migrations.core.DiscoveryService;
import ac.simons.neo4j.migrations.core.JavaBasedMigration;
import ac.simons.neo4j.migrations.core.Migration;
import ac.simons.neo4j.migrations.core.MigrationChain;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationType;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import ac.simons.neo4j.migrations.core.MigrationsException;
import ac.simons.neo4j.migrations.core.MigrationsLock;
import ac.simons.neo4j.migrations.core.StopWatch;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.NoSuchRecordException;
import org.neo4j.driver.types.Node;

public final class Migrations {
    private static final Logger LOGGER = Logger.getLogger(Migrations.class.getName());
    private final MigrationsConfig config;
    private final Driver driver;
    private final MigrationContext context;
    private final DiscoveryService discoveryService;
    private final ChainBuilder chainBuilder;

    public Migrations(MigrationsConfig config, Driver driver) {
        this.config = config;
        this.driver = driver;
        this.discoveryService = new DiscoveryService();
        this.chainBuilder = new ChainBuilder();
        this.context = new DefaultMigrationContext(this.config, this.driver);
    }

    public MigrationChain info() {
        return this.executeWithinLock(() -> {
            List<Migration> migrations = this.discoveryService.findMigrations(this.context);
            return this.chainBuilder.buildChain(this.context, migrations);
        });
    }

    public Optional<MigrationVersion> apply() {
        return this.executeWithinLock(() -> {
            List<Migration> migrations = this.discoveryService.findMigrations(this.context);
            this.apply0(migrations);
            return this.getLastAppliedVersion();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeWithinLock(Supplier<T> executable) {
        this.driver.verifyConnectivity();
        MigrationsLock lock = new MigrationsLock(this.context);
        try {
            lock.lock();
            T t = executable.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    private Optional<MigrationVersion> getLastAppliedVersion() {
        Optional<MigrationVersion> optional;
        block8: {
            Session session = this.context.getSession();
            try {
                Node lastMigration = (Node)session.readTransaction(tx -> tx.run("MATCH (l:__Neo4jMigration) WHERE NOT (l)-[:MIGRATED_TO]->(:__Neo4jMigration) RETURN l").single().get(0).asNode());
                String version = lastMigration.get("version").asString();
                String description = lastMigration.get("description").asString();
                optional = Optional.of(MigrationVersion.withValueAndDescription(version, description));
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchRecordException e) {
                    return Optional.empty();
                }
            }
            session.close();
        }
        return optional;
    }

    private void apply0(List<Migration> migrations) {
        MigrationVersion previousVersion = this.getLastAppliedVersion().orElseGet(MigrationVersion::baseline);
        MigrationChain chain = this.chainBuilder.buildChain(this.context, migrations);
        StopWatch stopWatch = new StopWatch();
        for (Migration migration : migrations) {
            if (previousVersion != MigrationVersion.baseline() && chain.isApplied(migration.getVersion().getValue())) {
                LOGGER.log(Level.INFO, "Skipping already applied migration {0}", Migrations.toString(migration));
                continue;
            }
            try {
                stopWatch.start();
                migration.apply(this.context);
                long executionTime = stopWatch.stop();
                previousVersion = this.recordApplication(chain.getUsername(), previousVersion, migration, executionTime);
                LOGGER.log(Level.INFO, "Applied migration {0}", Migrations.toString(migration));
            }
            catch (Exception e) {
                throw new MigrationsException("Could not apply migration: " + Migrations.toString(migration), e);
            }
            finally {
                stopWatch.reset();
            }
        }
    }

    private MigrationVersion recordApplication(String neo4jUser, MigrationVersion previousVersion, Migration appliedMigration, long executionTime) {
        try (Session session = this.context.getSession();){
            session.writeTransaction(t -> {
                Value parameters = Values.parameters((Object[])new Object[]{"neo4jUser", neo4jUser, "previousVersion", previousVersion.getValue(), "appliedMigration", Migrations.toProperties(appliedMigration), "installedBy", this.config.getInstalledBy(), "executionTime", executionTime});
                return t.run("MERGE (p:__Neo4jMigration {version: $previousVersion}) CREATE (c:__Neo4jMigration) SET c = $appliedMigration MERGE (p) - [:MIGRATED_TO {at: datetime({timezone: 'UTC'}), in: duration( {milliseconds: $executionTime} ), by: $installedBy, connectedAs: $neo4jUser}] -> (c)", parameters).consume();
            });
        }
        return appliedMigration.getVersion();
    }

    private static Map<String, Object> toProperties(Migration migration) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("version", migration.getVersion().getValue());
        properties.put("description", migration.getDescription());
        properties.put("type", Migrations.getMigrationType(migration).name());
        properties.put("source", migration.getSource());
        migration.getChecksum().ifPresent(checksum -> properties.put("checksum", (String)checksum));
        return Collections.unmodifiableMap(properties);
    }

    static MigrationType getMigrationType(Migration migration) {
        MigrationType type;
        if (migration instanceof JavaBasedMigration) {
            type = MigrationType.JAVA;
        } else if (migration instanceof CypherBasedMigration) {
            type = MigrationType.CYPHER;
        } else {
            throw new MigrationsException("Unknown migration type: " + migration.getClass());
        }
        return type;
    }

    static String toString(Migration migration) {
        return String.format("%s (\"%s\")", migration.getVersion(), migration.getDescription());
    }

    static class DefaultMigrationContext
    implements MigrationContext {
        private static final Method WITH_IMPERSONATED_USER = DefaultMigrationContext.findWithImpersonatedUser();
        private final MigrationsConfig config;
        private final Driver driver;
        private final SessionConfig sessionConfig;

        private static Method findWithImpersonatedUser() {
            try {
                return SessionConfig.Builder.class.getMethod("withImpersonatedUser", String.class);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        DefaultMigrationContext(MigrationsConfig config, Driver driver) {
            this.config = config;
            this.driver = driver;
            SessionConfig.Builder builder = SessionConfig.builder().withDefaultAccessMode(AccessMode.WRITE);
            if (this.config.getDatabase() != null && !this.config.getDatabase().trim().isEmpty()) {
                builder.withDatabase(this.config.getDatabase().trim());
            }
            if (this.config.getImpersonatedUser() != null && !this.config.getImpersonatedUser().trim().isEmpty()) {
                if (WITH_IMPERSONATED_USER == null) {
                    throw new IllegalArgumentException("User impersonation requires a driver that supports `withImpersonatedUser`.");
                }
                try {
                    WITH_IMPERSONATED_USER.invoke((Object)builder, this.getConfig().getImpersonatedUser().trim());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new MigrationsException("Could not impersonate a user on the driver level", e);
                }
            }
            this.sessionConfig = builder.build();
        }

        @Override
        public MigrationsConfig getConfig() {
            return this.config;
        }

        @Override
        public Driver getDriver() {
            return this.driver;
        }

        @Override
        public SessionConfig getSessionConfig() {
            return this.sessionConfig;
        }
    }
}

