/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.Defaults;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MigrationsConfig {
    static final String PREFIX_FILESYSTEM = "file";
    static final String PREFIX_CLASSPATH = "classpath";
    private final String[] packagesToScan;
    private final String[] locationsToScan;
    private final TransactionMode transactionMode;
    private final String database;
    private final String impersonatedUser;
    private final String installedBy;
    private final boolean validateOnMigrate;
    private final boolean autocrlf;

    public static Builder builder() {
        return new Builder();
    }

    public static MigrationsConfig defaultConfig() {
        return MigrationsConfig.builder().build();
    }

    private MigrationsConfig(Builder builder) {
        this.packagesToScan = builder.packagesToScan == null ? Defaults.PACKAGES_TO_SCAN.toArray(new String[0]) : builder.packagesToScan;
        this.locationsToScan = builder.locationsToScan == null ? Defaults.LOCATIONS_TO_SCAN.toArray(new String[0]) : builder.locationsToScan;
        this.transactionMode = Optional.ofNullable(builder.transactionMode).orElse(TransactionMode.PER_MIGRATION);
        this.database = builder.database;
        this.impersonatedUser = builder.impersonatedUser;
        this.installedBy = Optional.ofNullable(builder.installedBy).orElse(System.getProperty("user.name"));
        this.validateOnMigrate = builder.validateOnMigrate;
        this.autocrlf = builder.autocrlf;
    }

    public String[] getPackagesToScan() {
        return this.packagesToScan;
    }

    public String[] getLocationsToScan() {
        return this.locationsToScan;
    }

    public boolean hasPlacesToLookForMigrations() {
        return this.getPackagesToScan().length > 0 || this.getLocationsToScan().length > 0;
    }

    public TransactionMode getTransactionMode() {
        return this.transactionMode;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getImpersonatedUser() {
        return this.impersonatedUser;
    }

    public String getInstalledBy() {
        return this.installedBy;
    }

    public boolean isValidateOnMigrate() {
        return this.validateOnMigrate;
    }

    public boolean isAutocrlf() {
        return this.autocrlf;
    }

    public void logTo(Logger logger, boolean verbose) {
        if (!this.hasPlacesToLookForMigrations()) {
            logger.log(Level.WARNING, "Cannot find migrations as neither locations or packages to scan are configured!");
        }
        if (verbose && logger.isLoggable(Level.INFO)) {
            if (this.getDatabase() != null) {
                logger.log(Level.INFO, "Migrations will be applied to using database \"{0}\"", this.getDatabase());
            }
            if (this.getLocationsToScan().length > 0) {
                logger.log(Level.INFO, "Will search for Cypher scripts in \"{0}\"", String.join((CharSequence)"", this.getLocationsToScan()));
                logger.log(Level.INFO, "Statements will be applied {0}", this.getTransactionMode() == TransactionMode.PER_MIGRATION ? "in one transaction per migration" : "in separate transactions");
            }
            if (this.getPackagesToScan().length > 0) {
                logger.log(Level.INFO, "Will scan for Java based migrations in \"{0}\"", String.join((CharSequence)"", this.getPackagesToScan()));
            }
        }
    }

    public static class Builder {
        private String[] packagesToScan;
        private String[] locationsToScan;
        private TransactionMode transactionMode;
        private String database;
        private String impersonatedUser;
        private String installedBy;
        private boolean validateOnMigrate = true;
        private boolean autocrlf = false;

        public Builder withPackagesToScan(String ... packages) {
            this.packagesToScan = packages;
            return this;
        }

        public Builder withLocationsToScan(String ... locations) {
            this.locationsToScan = locations;
            return this;
        }

        public Builder withTransactionMode(TransactionMode newTransactionMode) {
            this.transactionMode = newTransactionMode;
            return this;
        }

        public Builder withDatabase(String newDatabase) {
            this.database = newDatabase;
            return this;
        }

        public Builder withInstalledBy(String newInstalledBy) {
            this.installedBy = newInstalledBy;
            return this;
        }

        public Builder withValidateOnMigrate(boolean newValidateOnMigrate) {
            this.validateOnMigrate = newValidateOnMigrate;
            return this;
        }

        public Builder withAutocrlf(boolean newAutocrlf) {
            this.autocrlf = newAutocrlf;
            return this;
        }

        public Builder withImpersonatedUser(String newImpersonatedUser) {
            this.impersonatedUser = newImpersonatedUser;
            return this;
        }

        public MigrationsConfig build() {
            return new MigrationsConfig(this);
        }
    }

    public static enum TransactionMode {
        PER_MIGRATION,
        PER_STATEMENT;

    }
}

