/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationsException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.driver.Session;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.summary.ResultSummary;

final class MigrationsLock {
    private static final Logger LOGGER = Logger.getLogger(MigrationsLock.class.getName());
    private static final String NAME_OF_LOCK = "John Doe";
    private final MigrationContext context;
    private final String id = UUID.randomUUID().toString();
    private final Thread cleanUpTask = new Thread(this::unlock0);

    MigrationsLock(MigrationContext context) {
        this.context = context;
    }

    void createUniqueConstraintIfNecessary() {
        block8: {
            try (Session session = this.context.getSession();){
                int numberOfConstraints = (Integer)session.writeTransaction(t -> {
                    int rv = t.run("CREATE CONSTRAINT ON (lock:__Neo4jMigrationsLock) ASSERT lock.id IS UNIQUE").consume().counters().constraintsAdded();
                    return rv += t.run("CREATE CONSTRAINT ON (lock:__Neo4jMigrationsLock) ASSERT lock.name IS UNIQUE").consume().counters().constraintsAdded();
                });
                LOGGER.log(Level.FINE, "Created {0} constraints", numberOfConstraints);
            }
            catch (Neo4jException e) {
                if ("Neo.ClientError.Schema.EquivalentSchemaRuleAlreadyExists".equals(e.code())) break block8;
                throw new MigrationsException("Could not ensure uniqueness of __Neo4jMigrationsLock. Please make sure your instance is in a clean state, no more than 1 lock should be there simultaneously!", e);
            }
        }
    }

    public String lock() {
        String string;
        block8: {
            LOGGER.log(Level.FINE, "Acquiring lock {0} on database", this.id);
            this.createUniqueConstraintIfNecessary();
            Session session = this.context.getSession();
            try {
                long internalId = (Long)session.writeTransaction(t -> t.run("CREATE (l:__Neo4jMigrationsLock {id: $id, name: $name}) RETURN l", Values.parameters((Object[])new Object[]{"id", this.id, "name", NAME_OF_LOCK})).single().get("l").asNode().id());
                LOGGER.log(Level.FINE, "Acquired lock {0} with internal id {1}", new Object[]{this.id, internalId});
                Runtime.getRuntime().addShutdownHook(this.cleanUpTask);
                string = this.id;
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Neo4jException e) {
                    throw new MigrationsException("Cannot create __Neo4jMigrationsLock node. Likely another migration is going on or has crashed", e);
                }
            }
            session.close();
        }
        return string;
    }

    public void unlock() {
        try {
            this.unlock0();
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(this.cleanUpTask);
        }
    }

    void unlock0() {
        try (Session session = this.context.getSession();){
            ResultSummary resultSummary = (ResultSummary)session.writeTransaction(t -> t.run("MATCH (l:__Neo4jMigrationsLock {id: $id}) DELETE l", Values.parameters((Object[])new Object[]{"id", this.id})).consume());
            LOGGER.log(Level.FINE, "Released lock {0} ({1} node(s) deleted)", new Object[]{this.id, resultSummary.counters().nodesDeleted()});
        }
    }
}

