/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import java.util.concurrent.TimeUnit;

final class StopWatch {
    private long start = -1L;
    private long stop = -1L;

    StopWatch() {
    }

    public void start() {
        if (this.start != -1L) {
            throw new IllegalStateException("Stopwatch already started.");
        }
        this.start = this.nanoTime();
    }

    public long stop() {
        if (this.start == -1L) {
            throw new IllegalStateException("Stopwatch not started.");
        }
        if (this.stop != -1L) {
            throw new IllegalStateException("Stopwatch already stopped.");
        }
        this.stop = this.nanoTime();
        return this.getTotalTimeMillis();
    }

    public void reset() {
        this.start = -1L;
        this.stop = -1L;
    }

    private long nanoTime() {
        return System.nanoTime();
    }

    private long getTotalTimeMillis() {
        if (this.start == -1L) {
            throw new IllegalStateException("Stopwatch not started.");
        }
        if (this.stop == -1L) {
            throw new IllegalStateException("Stopwatch not stopped.");
        }
        long duration = this.stop - this.start;
        return TimeUnit.NANOSECONDS.toMillis(duration);
    }
}

