/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.AbstractCypherBasedMigration;
import ac.simons.neo4j.migrations.core.CypherResource;
import ac.simons.neo4j.migrations.core.DefaultCypherResource;
import ac.simons.neo4j.migrations.core.MigrationWithPreconditions;
import ac.simons.neo4j.migrations.core.Precondition;
import ac.simons.neo4j.migrations.core.ResourceContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class CypherBasedMigration
extends AbstractCypherBasedMigration
implements MigrationWithPreconditions {
    private List<String> alternativeChecksums = Collections.emptyList();
    private volatile Optional<String> checksumOfNonePreconditions;

    CypherBasedMigration(ResourceContext context) {
        super(CypherResource.of(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<String> getChecksumWithoutPreconditions() {
        Optional<String> availableChecksum = this.checksumOfNonePreconditions;
        if (availableChecksum == null) {
            CypherBasedMigration cypherBasedMigration = this;
            synchronized (cypherBasedMigration) {
                availableChecksum = this.checksumOfNonePreconditions;
                if (availableChecksum == null) {
                    availableChecksum = this.checksumOfNonePreconditions = this.computeChecksumWithoutPreconditions();
                }
            }
        }
        return availableChecksum;
    }

    private Optional<String> computeChecksumWithoutPreconditions() {
        if (!(this.cypherResource instanceof DefaultCypherResource)) {
            return Optional.empty();
        }
        List<String> statements = ((DefaultCypherResource)this.cypherResource).getStatements().stream().map(statement -> {
            String quotedPatterns = DefaultCypherResource.getSingleLineComments(statement).filter(c -> Precondition.parse(c).isPresent()).map(String::trim).map(Pattern::quote).collect(Collectors.joining("|"));
            return quotedPatterns.isEmpty() ? statement : statement.replaceAll("(" + quotedPatterns + ")\r?\n|\r", "");
        }).toList();
        return Optional.of(DefaultCypherResource.computeChecksum(statements));
    }

    @Override
    public List<String> getAlternativeChecksums() {
        Optional<String> additionalAlternativeChecksum = this.getChecksumWithoutPreconditions();
        if (this.getChecksum().equals(additionalAlternativeChecksum)) {
            return Collections.unmodifiableList(this.alternativeChecksums);
        }
        ArrayList<String> alternateChecksums = new ArrayList<String>(this.alternativeChecksums);
        additionalAlternativeChecksum.ifPresent(alternateChecksums::add);
        return alternateChecksums;
    }

    @Override
    public void setAlternativeChecksums(List<String> alternativeChecksums) {
        Objects.requireNonNull(alternativeChecksums);
        this.alternativeChecksums = new ArrayList<String>(alternativeChecksums);
    }

    @Override
    public List<Precondition> getPreconditions() {
        return Precondition.in(this.cypherResource);
    }
}

