/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.DefaultCypherResource;
import ac.simons.neo4j.migrations.core.Defaults;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import ac.simons.neo4j.migrations.core.ResourceContext;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CypherResource {
    @Deprecated(forRemoval=true)
    public static CypherResource of(URL url) {
        return CypherResource.of(url, false);
    }

    @Deprecated(forRemoval=true)
    public static CypherResource of(URL url, boolean autocrlf) {
        return CypherResource.of(ResourceContext.of(url, MigrationsConfig.builder().withAutocrlf(autocrlf).build()));
    }

    public static CypherResource of(ResourceContext context) {
        URL url = context.getUrl();
        boolean autocrlf = context.getConfig().isAutocrlf();
        boolean useFlywayCompatibleChecksums = context.getConfig().isUseFlywayCompatibleChecksums();
        return new DefaultCypherResource(ResourceContext.generateIdentifierOf(url), autocrlf, useFlywayCompatibleChecksums, context::openStream);
    }

    public static WithContent withContent(String content) {
        return identifier -> new DefaultCypherResource(identifier, false, false, () -> new ByteArrayInputStream(content.getBytes(Defaults.CYPHER_SCRIPT_ENCODING)));
    }

    public String getIdentifier();

    public String getChecksum();

    public List<String> getExecutableStatements();

    public List<String> getSingleLineComments();

    public static interface WithContent {
        public CypherResource identifiedBy(String var1);
    }
}

