/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.CypherResource;
import ac.simons.neo4j.migrations.core.Defaults;
import ac.simons.neo4j.migrations.core.HBD;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import ac.simons.neo4j.migrations.core.MigrationsException;
import ac.simons.neo4j.migrations.core.internal.Strings;
import ac.simons.neo4j.migrations.core.refactorings.Counters;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.SimpleQueryRunner;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.SummaryCounters;

final class DefaultCypherResource
implements CypherResource {
    private static final Logger LOGGER = Logger.getLogger(DefaultCypherResource.class.getName());
    private static final char BOM = '\ufeff';
    private static final Predicate<String> NOT_A_SINGLE_COMMENT = s -> {
        if (!Strings.isSingleLineComment(s)) {
            if (s.trim().startsWith("//")) {
                return Arrays.stream(s.split("\r?\n|\r")).anyMatch(sub -> !Strings.isSingleLineComment(sub));
            }
            return true;
        }
        return false;
    };
    private static final String USE_DATABASE_EXPRESSION = "(?i):use +([a-z][a-z\\d.\\-]{2,62})(?:;?(?:\r?\n|\r)?)?";
    private static final String CYPHER_STATEMENT_DELIMITER = ";(?:\r?\n|\r)";
    private static final Pattern USE_DATABASE_PATTERN = Pattern.compile("(?i):use +([a-z][a-z\\d.\\-]{2,62})(?:;?(?:\r?\n|\r)?)?");
    private static final Pattern CALL_PATTERN = Pattern.compile("(?ims)(?<!`)([^`\\s*+]\\s*+CALL\\s*+(?:\\(.+?\\)\\s*+)?\\{.*}\\s*+(?<transactionClause>IN(?<concurrency>.+?)TRANSACTIONS)?)(?!`)");
    private static final Pattern PATTERN_CALL_CONCURRENCY = Pattern.compile("(?ims)(-\\d+|\\d+)?\\s*CONCURRENT");
    private static final Pattern USING_PERIODIC_PATTERN = Pattern.compile("(?ims)(?<!`)(([^`\\s*]|^)\\s*+USING\\s+PERIODIC\\s+COMMIT\\s+)(?!`)");
    private final String identifier;
    private final boolean autocrlf;
    private final Supplier<InputStream> inputStreamSupplier;
    private final boolean useFlywayCompatibleChecksums;
    private volatile List<String> statements;
    private volatile String checksum;

    DefaultCypherResource(String identifier, boolean autocrlf, boolean useFlywayCompatibleChecksums, Supplier<InputStream> inputStreamSupplier) {
        this.identifier = identifier;
        this.autocrlf = autocrlf;
        this.useFlywayCompatibleChecksums = useFlywayCompatibleChecksums;
        this.inputStreamSupplier = inputStreamSupplier;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getChecksum() {
        String availableChecksum = this.checksum;
        if (availableChecksum == null) {
            DefaultCypherResource defaultCypherResource = this;
            synchronized (defaultCypherResource) {
                availableChecksum = this.checksum;
                if (availableChecksum == null) {
                    availableChecksum = this.checksum = this.computeChecksum();
                }
            }
        }
        return availableChecksum;
    }

    private String computeChecksum() {
        return this.useFlywayCompatibleChecksums ? this.flywayCompatChecksum() : DefaultCypherResource.computeChecksum(this.getStatements());
    }

    private static String filterBomFromString(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (s.charAt(0) == '\ufeff') {
            return s.substring(1);
        }
        return s;
    }

    private String flywayCompatChecksum() {
        CRC32 crc32 = new CRC32();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.inputStreamSupplier.get()), 4096);){
            String line = bufferedReader.readLine();
            if (line != null) {
                line = DefaultCypherResource.filterBomFromString(line);
                do {
                    crc32.update(line.getBytes(StandardCharsets.UTF_8));
                } while ((line = bufferedReader.readLine()) != null);
            }
        }
        catch (IOException e) {
            throw new MigrationsException("Unable to calculate checksum of " + this.identifier + "\r\n" + e.getMessage(), e);
        }
        return Integer.toString((int)crc32.getValue());
    }

    static String computeChecksum(Collection<String> statements) {
        CRC32 crc32 = new CRC32();
        for (String statement : statements) {
            byte[] bytes = statement.getBytes(Defaults.CYPHER_SCRIPT_ENCODING);
            crc32.update(bytes, 0, bytes.length);
        }
        return Long.toString(crc32.getValue());
    }

    List<String> getStatements() {
        return this.getStatements(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getStatements(Predicate<String> filter) {
        List<String> availableStatements = this.statements;
        if (availableStatements == null) {
            DefaultCypherResource defaultCypherResource = this;
            synchronized (defaultCypherResource) {
                availableStatements = this.statements;
                if (availableStatements == null) {
                    availableStatements = this.statements = this.readStatements();
                }
            }
        }
        return filter == null ? availableStatements : availableStatements.stream().filter(filter).toList();
    }

    private List<String> readStatements() {
        ArrayList<String> newStatements = new ArrayList<String>();
        try (Scanner scanner = new Scanner(this.inputStreamSupplier.get(), Defaults.CYPHER_SCRIPT_ENCODING).useDelimiter(CYPHER_STATEMENT_DELIMITER);){
            while (scanner.hasNext()) {
                String statement = scanner.next().trim().replaceAll(";$", "").trim();
                if (this.autocrlf) {
                    statement = statement.replace("\r\n", "\n");
                }
                if (statement.isEmpty()) continue;
                Matcher useMatcher = USE_DATABASE_PATTERN.matcher(statement);
                boolean isMultiLine = statement.contains("\n");
                StringBuffer finalStatement = new StringBuffer();
                if (useMatcher.find()) {
                    DefaultCypherResource.handleUseStatement(newStatements, useMatcher, finalStatement);
                }
                while (useMatcher.find()) {
                    if (isMultiLine) {
                        useMatcher.appendTail(finalStatement);
                        throw new MigrationsException("Can't switch database inside a statement, offending statement:\n" + String.valueOf(finalStatement));
                    }
                    DefaultCypherResource.handleUseStatement(newStatements, useMatcher, finalStatement);
                }
                useMatcher.appendTail(finalStatement);
                if (finalStatement.isEmpty()) continue;
                newStatements.add(finalStatement.toString());
            }
        }
        return Collections.unmodifiableList(newStatements);
    }

    private static void handleUseStatement(List<String> newStatements, Matcher useMatcher, StringBuffer finalStatement) {
        useMatcher.appendReplacement(finalStatement, "");
        newStatements.add(useMatcher.group(0).trim());
    }

    @Override
    public List<String> getExecutableStatements() {
        return this.getStatements(NOT_A_SINGLE_COMMENT);
    }

    @Override
    public List<String> getSingleLineComments() {
        return this.getStatements().stream().flatMap(DefaultCypherResource::getSingleLineComments).toList();
    }

    static Stream<String> getSingleLineComments(String statement) {
        if (!statement.startsWith("//")) {
            return Stream.empty();
        }
        Stream.Builder<String> builder = Stream.builder();
        for (String line : statement.split("\r?\n|\r")) {
            boolean notAComment;
            boolean bl = notAComment = !(line = line.trim()).startsWith("//");
            if (notAComment) break;
            builder.add(line);
        }
        return builder.build();
    }

    static Optional<String> getDatabaseName(String line) {
        Matcher matcher = USE_DATABASE_PATTERN.matcher(line);
        if (matcher.matches()) {
            return Optional.of(matcher.group(1).toLowerCase(Locale.ROOT));
        }
        return Optional.empty();
    }

    static void executeIn(CypherResource cypherResource, MigrationContext context, UnaryOperator<SessionConfig.Builder> sessionCustomizer) {
        List<DatabaseAndStatements> statementsByDatabase = DefaultCypherResource.groupStatements(cypherResource.getExecutableStatements());
        statementsByDatabase.forEach(databaseAndStatements -> {
            UnaryOperator finalSessionCustomizer = databaseAndStatements.database().map(database -> builder -> builder.withDatabase(database)).orElse(sessionCustomizer);
            try (Session session = context.getDriver().session(context.getSessionConfig(finalSessionCustomizer));){
                int numberOfStatements;
                List<String> executableStatements = databaseAndStatements.statements();
                Set<String> statementsNeedingImplicitTransactions = executableStatements.stream().filter(statement -> DefaultCypherResource.getTransactionMode(statement) == TransactionMode.IMPLICIT).collect(Collectors.toSet());
                MigrationsConfig.TransactionMode transactionMode = context.getConfig().getTransactionMode();
                TransactionConfig transactionConfig = Optional.ofNullable(context.getConfig().getTransactionTimeout()).map(arg_0 -> ((TransactionConfig.Builder)TransactionConfig.builder()).withTimeout(arg_0)).orElse(TransactionConfig.builder().withDefaultTimeout()).build();
                if (transactionMode == MigrationsConfig.TransactionMode.PER_STATEMENT || !statementsNeedingImplicitTransactions.isEmpty()) {
                    LOGGER.log(Level.FINE, "Executing statements contained in script \"{0}\" in separate transactions", cypherResource.getIdentifier());
                    numberOfStatements = DefaultCypherResource.executeInSeparateTransactions(session, transactionConfig, executableStatements, statementsNeedingImplicitTransactions);
                } else if (transactionMode == MigrationsConfig.TransactionMode.PER_MIGRATION) {
                    LOGGER.log(Level.FINE, "Executing statements in script \"{0}\" in one transaction", cypherResource.getIdentifier());
                    Counters c = Counters.empty();
                    numberOfStatements = (Integer)session.executeWrite(t -> {
                        int cnt = 0;
                        for (String statement : executableStatements) {
                            c.add(DefaultCypherResource.run((SimpleQueryRunner)t, statement));
                            ++cnt;
                        }
                        return cnt;
                    }, transactionConfig);
                    HBD.vladimirAndEstragonMayWait(session, c);
                } else {
                    throw new MigrationsException("Unknown transaction mode " + String.valueOf((Object)transactionMode));
                }
                LOGGER.log(Level.FINE, "Executed {0} statements", numberOfStatements);
            }
        });
    }

    private static int executeInSeparateTransactions(Session session, TransactionConfig transactionConfig, List<String> executableStatements, Set<String> statementsNeedingImplicitTransactions) {
        int numberOfStatements = 0;
        Counters counters = Counters.empty();
        for (String statement : executableStatements) {
            if (statementsNeedingImplicitTransactions.contains(statement)) {
                ++numberOfStatements;
                DefaultCypherResource.run((SimpleQueryRunner)session, statement);
                continue;
            }
            numberOfStatements += ((Integer)session.executeWrite(t -> {
                DefaultCypherResource.run((SimpleQueryRunner)t, statement);
                return 1;
            }, transactionConfig)).intValue();
        }
        HBD.vladimirAndEstragonMayWait(session, counters);
        return numberOfStatements;
    }

    static TransactionMode getTransactionMode(String statement) {
        if (USING_PERIODIC_PATTERN.matcher(statement).find()) {
            return TransactionMode.IMPLICIT;
        }
        Matcher callMatcher = CALL_PATTERN.matcher(statement);
        if (!callMatcher.find()) {
            return TransactionMode.MANAGED;
        }
        String transactionClause = callMatcher.group("transactionClause");
        if (transactionClause == null) {
            return TransactionMode.MANAGED;
        }
        String concurrency = callMatcher.group("concurrency");
        if (concurrency.isBlank() || PATTERN_CALL_CONCURRENCY.matcher(concurrency.trim()).matches()) {
            return TransactionMode.IMPLICIT;
        }
        throw new MigrationsException("Invalid statement: " + statement);
    }

    static List<DatabaseAndStatements> groupStatements(List<String> statements) {
        ArrayList<DatabaseAndStatements> result = new ArrayList<DatabaseAndStatements>();
        Optional<String> current = Optional.empty();
        ArrayList<String> sublist = new ArrayList<String>();
        for (String statement : statements) {
            Optional<String> databaseName = DefaultCypherResource.getDatabaseName(statement);
            if (databaseName.isPresent()) {
                result.add(new DatabaseAndStatements(current, sublist));
                current = databaseName;
                sublist = new ArrayList();
                continue;
            }
            sublist.add(statement);
        }
        result.add(new DatabaseAndStatements(current, sublist));
        return result;
    }

    static Counters run(SimpleQueryRunner runner, String statement) {
        LOGGER.log(Level.FINE, "Running {0}", statement);
        ResultSummary resultSummary = runner.run(statement).consume();
        SummaryCounters c = resultSummary.counters();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "nodesCreated: {0}, nodesDeleted: {1}, relationshipsCreated: {2}, relationshipsDeleted: {3}, propertiesSet: {4}, labelsAdded: {5}, labelsRemoved: {6}, indexesAdded: {7}, indexesRemoved: {8}, constraintsAdded: {9}, constraintsRemoved: {10}", new Object[]{c.nodesCreated(), c.nodesDeleted(), c.relationshipsCreated(), c.relationshipsDeleted(), c.propertiesSet(), c.labelsAdded(), c.labelsRemoved(), c.indexesAdded(), c.indexesRemoved(), c.constraintsAdded(), c.constraintsRemoved()});
        }
        return Counters.of(c);
    }

    static enum TransactionMode {
        MANAGED,
        IMPLICIT;

    }

    record DatabaseAndStatements(Optional<String> database, List<String> statements) {
        DatabaseAndStatements {
            statements = List.copyOf(statements);
        }
    }
}

