/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.ConnectionDetails;
import ac.simons.neo4j.migrations.core.MigrationChain;
import ac.simons.neo4j.migrations.core.MigrationState;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

final class DefaultMigrationChain
implements MigrationChain {
    private final ConnectionDetails connectionDetailsDelegate;
    private final Map<MigrationVersion, MigrationChain.Element> elements;

    DefaultMigrationChain(ConnectionDetails connectionDetailsDelegate, Map<MigrationVersion, MigrationChain.Element> elements) {
        this.connectionDetailsDelegate = connectionDetailsDelegate;
        this.elements = elements;
    }

    @Override
    public String getServerAddress() {
        return this.connectionDetailsDelegate.getServerAddress();
    }

    @Override
    public String getServerVersion() {
        return this.connectionDetailsDelegate.getServerVersion();
    }

    @Override
    public String getServerEdition() {
        return this.connectionDetailsDelegate.getServerEdition();
    }

    @Override
    public String getUsername() {
        return this.connectionDetailsDelegate.getUsername();
    }

    @Override
    public Optional<String> getOptionalDatabaseName() {
        return this.connectionDetailsDelegate.getOptionalDatabaseName();
    }

    @Override
    public Optional<String> getOptionalSchemaDatabaseName() {
        return this.connectionDetailsDelegate.getOptionalSchemaDatabaseName();
    }

    @Override
    public boolean isApplied(String version) {
        MigrationChain.Element element = this.elements.get(MigrationVersion.withValue(version));
        return element != null && element.getState() == MigrationState.APPLIED;
    }

    @Override
    public Collection<MigrationChain.Element> getElements() {
        return this.elements.values();
    }

    @Override
    public Optional<MigrationVersion> findTargetVersion(MigrationVersion.TargetVersion targetVersion) {
        if (this.elements.isEmpty()) {
            return Optional.empty();
        }
        return switch (targetVersion) {
            default -> throw new IncompatibleClassChangeError();
            case MigrationVersion.TargetVersion.CURRENT -> this.getLastAppliedVersion();
            case MigrationVersion.TargetVersion.LATEST -> this.elements.keySet().stream().skip((long)this.elements.size() - 1L).findFirst();
            case MigrationVersion.TargetVersion.NEXT -> this.elements.entrySet().stream().dropWhile(e -> ((MigrationChain.Element)e.getValue()).getState() == MigrationState.APPLIED).map(Map.Entry::getKey).findFirst();
        };
    }

    @Override
    public Optional<MigrationVersion> getLastAppliedVersion() {
        Map.Entry<MigrationVersion, MigrationChain.Element> next;
        Iterator<Map.Entry<MigrationVersion, MigrationChain.Element>> it = this.elements.entrySet().iterator();
        MigrationVersion version = null;
        while (it.hasNext() && (next = it.next()).getValue().getState() == MigrationState.APPLIED) {
            version = next.getKey();
        }
        return Optional.ofNullable(version);
    }
}

