/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.ConnectionDetails;
import ac.simons.neo4j.migrations.core.DefaultCatalog;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import ac.simons.neo4j.migrations.core.MigrationsException;
import ac.simons.neo4j.migrations.core.VersionedCatalog;
import ac.simons.neo4j.migrations.core.catalog.Catalog;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.UnaryOperator;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.BookmarkManager;
import org.neo4j.driver.BookmarkManagerConfig;
import org.neo4j.driver.BookmarkManagers;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.TransactionCallback;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.summary.DatabaseInfo;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.ServerInfo;

final class DefaultMigrationContext
implements MigrationContext {
    private static final Method WITH_IMPERSONATED_USER = DefaultMigrationContext.findWithImpersonatedUser();
    private final UnaryOperator<SessionConfig.Builder> applySchemaDatabase;
    private final MigrationsConfig config;
    private final BookmarkManager bookmarkManager;
    private final Driver driver;
    private volatile ConnectionDetails connectionDetails;
    private final VersionedCatalog catalog;

    private static Method findWithImpersonatedUser() {
        try {
            return SessionConfig.Builder.class.getMethod("withImpersonatedUser", String.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    DefaultMigrationContext(MigrationsConfig config, Driver driver) {
        if (config.getOptionalImpersonatedUser().isPresent() && WITH_IMPERSONATED_USER == null) {
            throw new IllegalArgumentException("User impersonation requires a driver that supports `withImpersonatedUser`.");
        }
        this.config = config;
        this.bookmarkManager = BookmarkManagers.defaultManager((BookmarkManagerConfig)BookmarkManagerConfig.builder().build());
        this.driver = (Driver)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Driver.class}, (InvocationHandler)new DriverProxy(this.bookmarkManager, driver));
        this.applySchemaDatabase = this.config.getOptionalSchemaDatabase().map(schemaDatabase -> builder -> builder.withDatabase(schemaDatabase)).orElseGet(UnaryOperator::identity);
        this.catalog = new DefaultCatalog(config.getVersionComparator());
    }

    @Override
    public MigrationsConfig getConfig() {
        return this.config;
    }

    @Override
    public Driver getDriver() {
        return this.driver;
    }

    @Override
    public SessionConfig getSessionConfig() {
        return this.getSessionConfig(UnaryOperator.identity());
    }

    @Override
    public SessionConfig getSessionConfig(UnaryOperator<SessionConfig.Builder> configCustomizer) {
        SessionConfig.Builder builder = SessionConfig.builder().withDefaultAccessMode(AccessMode.WRITE).withBookmarkManager(this.bookmarkManager);
        this.config.getOptionalDatabase().ifPresent(arg_0 -> ((SessionConfig.Builder)builder).withDatabase(arg_0));
        this.config.getOptionalImpersonatedUser().ifPresent(user -> DefaultMigrationContext.setWithImpersonatedUser(builder, user));
        return ((SessionConfig.Builder)configCustomizer.apply(builder)).build();
    }

    static void setWithImpersonatedUser(SessionConfig.Builder builder, String user) {
        try {
            WITH_IMPERSONATED_USER.invoke((Object)builder, user);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new MigrationsException("Could not impersonate a user on the driver level", e);
        }
    }

    static SessionConfig.Builder copyIntoBuilder(SessionConfig sessionConfig) {
        SessionConfig.Builder builder = SessionConfig.builder();
        builder.withBookmarks(sessionConfig.bookmarks());
        sessionConfig.database().ifPresent(arg_0 -> ((SessionConfig.Builder)builder).withDatabase(arg_0));
        builder.withDefaultAccessMode(sessionConfig.defaultAccessMode());
        sessionConfig.fetchSize().ifPresent(arg_0 -> ((SessionConfig.Builder)builder).withFetchSize(arg_0));
        sessionConfig.impersonatedUser().ifPresent(user -> DefaultMigrationContext.setWithImpersonatedUser(builder, user));
        return builder;
    }

    @Override
    public Session getSchemaSession() {
        return this.getDriver().session(this.getSessionConfig(this.applySchemaDatabase));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionDetails getConnectionDetails() {
        ConnectionDetails availableConnectionDetails = this.connectionDetails;
        if (availableConnectionDetails == null) {
            DefaultMigrationContext defaultMigrationContext = this;
            synchronized (defaultMigrationContext) {
                availableConnectionDetails = this.connectionDetails;
                if (availableConnectionDetails == null) {
                    availableConnectionDetails = this.connectionDetails = this.getConnectionDetails0();
                }
            }
        }
        return availableConnectionDetails;
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    private boolean hasDbmsProcedures() {
        boolean bl;
        block9: {
            Session session = this.getSchemaSession();
            try {
                ResultSummary consume = session.run("EXPLAIN CALL dbms.procedures() YIELD name RETURN count(*)").consume();
                bl = consume.notifications().stream().map(Notification::code).noneMatch("Neo.ClientNotification.Statement.FeatureDeprecationWarning"::equals);
                if (session == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ClientException e) {
                    if ("Neo.ClientError.Procedure.ProcedureNotFound".equals(e.code())) {
                        return false;
                    }
                    throw e;
                }
            }
            session.close();
        }
        return bl;
    }

    private ConnectionDetails getConnectionDetails0() {
        TransactionCallback extendedResultSummaryTransactionWork = this.hasDbmsProcedures() ? tx -> {
            Result result = tx.run("CALL dbms.procedures() YIELD name\nWHERE name = 'dbms.showCurrentUser'\nWITH count(*) > 0 AS showCurrentUserExists\nCALL dbms.components() YIELD name, versions, edition\nWHERE name = 'Neo4j Kernel'\nRETURN showCurrentUserExists, 'Neo4j/' + versions[0] AS version, edition");
            Record singleResultRecord = result.single();
            boolean showCurrentUserExists = singleResultRecord.get("showCurrentUserExists").asBoolean();
            String version = singleResultRecord.get("version").asString();
            String edition = singleResultRecord.get("edition").asString();
            ResultSummary summary = result.consume();
            return new ExtendedResultSummary(showCurrentUserExists, version, edition, summary);
        } : tx -> {
            boolean showCurrentUserExists = tx.run("SHOW PROCEDURES YIELD name WHERE name = 'dbms.showCurrentUser' RETURN count(*)").single().get(0).asInt() == 1;
            Result result = tx.run("CALL dbms.components() YIELD name, versions, edition\nWHERE name = 'Neo4j Kernel'\nRETURN 'Neo4j/' + versions[0] AS version, edition");
            Record singleResultRecord = result.single();
            String version = singleResultRecord.get("version").asString();
            String edition = singleResultRecord.get("edition").asString();
            ResultSummary summary = result.consume();
            return new ExtendedResultSummary(showCurrentUserExists, version, edition, summary);
        };
        try (Session session = this.getSchemaSession();){
            ExtendedResultSummary databaseInformation = (ExtendedResultSummary)session.executeRead(extendedResultSummaryTransactionWork);
            String username = "anonymous";
            if (databaseInformation.showCurrentUserExists) {
                username = (String)session.executeRead(tx -> tx.run("CALL dbms.showCurrentUser() YIELD username RETURN username").single().get("username").asString());
            }
            ServerInfo serverInfo = databaseInformation.server;
            String schemaDatabase = databaseInformation.database == null ? null : databaseInformation.database.name();
            String targetDatabase = this.getConfig().getMigrationTargetIn(this).orElse(schemaDatabase);
            ConnectionDetails connectionDetails = ConnectionDetails.of(serverInfo.address(), databaseInformation.version, databaseInformation.edition, username, targetDatabase, schemaDatabase);
            return connectionDetails;
        }
    }

    static class DriverProxy
    implements InvocationHandler {
        private final BookmarkManager bookmarkManager;
        private final Driver target;

        DriverProxy(BookmarkManager bookmarkManager, Driver target) {
            this.bookmarkManager = bookmarkManager;
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if ("session".equals(method.getName())) {
                    SessionConfig existingConfig;
                    SessionConfig sessionConfig = args.length == 0 ? SessionConfig.builder().withBookmarkManager(this.bookmarkManager).build() : ((existingConfig = (SessionConfig)args[0]).bookmarkManager().isPresent() ? existingConfig : DefaultMigrationContext.copyIntoBuilder(existingConfig).withBookmarkManager(this.bookmarkManager).build());
                    return this.target.session(sessionConfig);
                }
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
    }

    record ExtendedResultSummary(boolean showCurrentUserExists, String version, String edition, ServerInfo server, DatabaseInfo database) {
        ExtendedResultSummary(boolean showCurrentUserExists, String version, String edition, ResultSummary actualSummary) {
            this(showCurrentUserExists, version, edition, actualSummary.server(), actualSummary.database());
        }
    }
}

