/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.Callback;
import ac.simons.neo4j.migrations.core.CatalogBasedMigration;
import ac.simons.neo4j.migrations.core.ClasspathResourceScanner;
import ac.simons.neo4j.migrations.core.DefaultClasspathResourceScanner;
import ac.simons.neo4j.migrations.core.Discoverer;
import ac.simons.neo4j.migrations.core.JavaBasedMigrationDiscoverer;
import ac.simons.neo4j.migrations.core.LifecyclePhase;
import ac.simons.neo4j.migrations.core.Migration;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import ac.simons.neo4j.migrations.core.MigrationWithPreconditions;
import ac.simons.neo4j.migrations.core.Migrations;
import ac.simons.neo4j.migrations.core.MigrationsException;
import ac.simons.neo4j.migrations.core.Precondition;
import ac.simons.neo4j.migrations.core.ResourceDiscoverer;
import ac.simons.neo4j.migrations.core.WriteableCatalog;
import ac.simons.neo4j.migrations.core.catalog.Catalog;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class DiscoveryService {
    private final List<Discoverer<? extends Migration>> migrationDiscoverers;
    private final List<Discoverer<Callback>> callbackDiscoverers;

    DiscoveryService() {
        this(new JavaBasedMigrationDiscoverer(), new DefaultClasspathResourceScanner());
    }

    DiscoveryService(Discoverer<? extends Migration> migrationClassesDiscoverer, ClasspathResourceScanner resourceScanner) {
        this.migrationDiscoverers = List.of(migrationClassesDiscoverer, ResourceDiscoverer.forMigrations(resourceScanner));
        this.callbackDiscoverers = List.of(ResourceDiscoverer.forCallbacks(resourceScanner));
    }

    List<Migration> findMigrations(MigrationContext context) {
        ArrayList<? extends Migration> migrations = new ArrayList<Migration>();
        try {
            for (Discoverer<? extends Migration> discoverer : this.migrationDiscoverers) {
                migrations.addAll(discoverer.discover(context));
            }
        }
        catch (Exception e) {
            throw new MigrationsException("Unexpected error while scanning for migrations", e);
        }
        List<MigrationWithPreconditions> cypherBasedMigrations = migrations.stream().filter(MigrationWithPreconditions.class::isInstance).map(MigrationWithPreconditions.class::cast).toList();
        HashMap<Migration, List<Precondition>> migrationsAndPreconditions = new HashMap<Migration, List<Precondition>>();
        this.computeAlternativeChecksums(cypherBasedMigrations, migrationsAndPreconditions);
        migrations.removeIf(migration -> this.hasUnmetPreconditions((Map<Migration, List<Precondition>>)migrationsAndPreconditions, (Migration)migration, context));
        migrations.sort(Comparator.comparing(Migration::getVersion, context.getConfig().getVersionComparator()));
        Catalog catalog = context.getCatalog();
        if (catalog instanceof WriteableCatalog) {
            WriteableCatalog writeableSchema = (WriteableCatalog)catalog;
            migrations.stream().filter(CatalogBasedMigration.class::isInstance).map(CatalogBasedMigration.class::cast).forEach(m -> writeableSchema.addAll(m.getVersion(), m.getCatalog(), m.isResetCatalog()));
        }
        Map<MigrationVersion, List<Migration>> groupedByVersion = migrations.stream().collect(Collectors.groupingBy(Migration::getVersion));
        for (Map.Entry<MigrationVersion, List<Migration>> entry : groupedByVersion.entrySet()) {
            List<Migration> v = entry.getValue();
            if (v.size() <= 1) continue;
            MigrationVersion k = entry.getKey();
            String sources = v.stream().map(Migration::getSource).sorted().collect(Collectors.joining(", "));
            throw new MigrationsException("Duplicate version '" + k.getValue() + "' (" + sources + ")");
        }
        return List.copyOf(migrations);
    }

    private void computeAlternativeChecksums(List<MigrationWithPreconditions> migrations, Map<Migration, List<Precondition>> migrationsAndPreconditions) {
        migrations.forEach(m -> {
            List<Precondition> preconditions = m.getPreconditions();
            migrationsAndPreconditions.put((Migration)m, preconditions);
        });
        migrations.forEach(m -> {
            if (((List)migrationsAndPreconditions.get(m)).isEmpty()) {
                return;
            }
            List<String> alternativeChecksums = migrations.stream().filter(o -> o != m && o.getSource().equals(m.getSource()) && !((List)migrationsAndPreconditions.get(o)).isEmpty()).flatMap(o -> {
                Stream<String> checksum = o.getChecksum().stream();
                return Stream.concat(checksum, o.getAlternativeChecksums().stream()).distinct();
            }).toList();
            m.setAlternativeChecksums(alternativeChecksums);
        });
    }

    boolean hasUnmetPreconditions(Map<Migration, List<Precondition>> migrationsAndPreconditions, Migration migration, MigrationContext context) {
        if (!(migration instanceof MigrationWithPreconditions)) {
            return false;
        }
        Map<Precondition.Type, List<Precondition>> preconditions = migrationsAndPreconditions.get(migration).stream().collect(Collectors.groupingBy(Precondition::getType));
        if (preconditions.isEmpty()) {
            return false;
        }
        for (Precondition assertion : preconditions.getOrDefault((Object)Precondition.Type.ASSERTION, List.of())) {
            if (assertion.isMet(context)) continue;
            throw new MigrationsException("Could not satisfy `" + String.valueOf(assertion) + "`.");
        }
        List<Precondition> unmet = preconditions.getOrDefault((Object)Precondition.Type.ASSUMPTION, List.of()).stream().filter(precondition -> !precondition.isMet(context)).toList();
        if (unmet.isEmpty()) {
            return false;
        }
        Migrations.LOGGER.log(Level.INFO, () -> String.format("Skipping %s due to unmet preconditions:%n%s", Migrations.toString(migration), unmet.stream().map((Function<Precondition, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lac/simons/neo4j/migrations/core/Precondition;)Ljava/lang/String;)()).collect(Collectors.joining(System.lineSeparator()))));
        return true;
    }

    Map<LifecyclePhase, List<Callback>> findCallbacks(MigrationContext context) {
        return this.callbackDiscoverers.stream().flatMap(d -> d.discover(context).stream()).collect(Collectors.collectingAndThen(Collectors.groupingBy(Callback::getPhase, Collectors.collectingAndThen(Collectors.toList(), l -> {
            l.sort(Comparator.comparing(c -> c.getOptionalDescription().orElse("")));
            return List.copyOf(l);
        })), Map::copyOf));
    }
}

