/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.Migration;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import ac.simons.neo4j.migrations.core.Migrations;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import ac.simons.neo4j.migrations.core.MigrationsException;
import java.time.Duration;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;

final class IterableMigrations
implements Iterable<Migration> {
    private final MigrationsConfig config;
    private final List<Migration> migrations;
    private final MigrationVersion optionalStop;

    static IterableMigrations of(MigrationsConfig config, List<Migration> migrations) {
        return IterableMigrations.of(config, migrations, null);
    }

    static IterableMigrations of(MigrationsConfig config, List<Migration> migrations, MigrationVersion.StopVersion stopVersion) {
        MigrationVersion optionalStop;
        if (stopVersion == null) {
            optionalStop = null;
        } else {
            optionalStop = stopVersion.version();
            if (!stopVersion.optional() && migrations.stream().filter(m -> m.getVersion().equals(optionalStop)).findFirst().isEmpty()) {
                throw new MigrationsException("Target version %s is not available".formatted(optionalStop.getValue()));
            }
        }
        return new IterableMigrations(config, migrations, optionalStop);
    }

    private IterableMigrations(MigrationsConfig config, List<Migration> migrations, MigrationVersion optionalStop) {
        this.config = config;
        this.migrations = migrations;
        this.optionalStop = optionalStop;
    }

    @Override
    public Iterator<Migration> iterator() {
        Iterator<Migration> iterator = this.migrations.iterator();
        if (this.optionalStop != null) {
            Migrations.LOGGER.log(Level.INFO, "Will stop at target version {0}", this.optionalStop);
        }
        return new DelayingIterator(iterator, this.config.getOptionalDelayBetweenMigrations().orElse(null), this.config.getVersionComparator(), this.optionalStop);
    }

    private static final class DelayingIterator
    implements Iterator<Migration> {
        private final Iterator<Migration> delegate;
        private final Duration optionalDelay;
        private final Comparator<MigrationVersion> comparator;
        private final MigrationVersion optionalStop;
        private Migration next;

        DelayingIterator(Iterator<Migration> delegate, Duration optionalDelay, Comparator<MigrationVersion> comparator, MigrationVersion optionalStop) {
            this.delegate = delegate;
            this.optionalDelay = optionalDelay;
            this.comparator = comparator;
            this.optionalStop = optionalStop;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.delegate.hasNext();
            if (hasNext) {
                this.next = this.delegate.next();
                hasNext = this.optionalStop == null || this.comparator.compare(this.next.getVersion(), this.optionalStop) <= 0;
            } else {
                this.next = null;
            }
            return hasNext;
        }

        @Override
        public Migration next() throws NoSuchElementException {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (this.optionalDelay != null) {
                try {
                    Thread.sleep(this.optionalDelay.toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.next;
        }
    }
}

