/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.ConnectionDetails;
import ac.simons.neo4j.migrations.core.ConnectionDetailsFormatter;
import ac.simons.neo4j.migrations.core.DefaultMigrationChain;
import ac.simons.neo4j.migrations.core.MigrationChainFormat;
import ac.simons.neo4j.migrations.core.MigrationState;
import ac.simons.neo4j.migrations.core.MigrationType;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface MigrationChain
extends ConnectionDetails {
    public static MigrationChain empty(ConnectionDetails connectionDetails) {
        return new DefaultMigrationChain(connectionDetails, Map.of());
    }

    default public String prettyPrint() {
        StringBuilder sb = new StringBuilder(ConnectionDetailsFormatter.INSTANCE.format(this)).append(MigrationChainFormat.LS).append(MigrationChainFormat.LS);
        if (this.getElements().isEmpty()) {
            sb.append(MigrationChainFormat.LS).append("No migrations found.");
        } else {
            MigrationChainFormat.formatElements(this, sb);
        }
        return sb.toString();
    }

    public boolean isApplied(String var1);

    public Collection<Element> getElements();

    default public int length() {
        return this.getElements().size();
    }

    default public Optional<MigrationVersion> getLastAppliedVersion() {
        return Optional.empty();
    }

    public Optional<MigrationVersion> findTargetVersion(MigrationVersion.TargetVersion var1);

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Element {
        public MigrationState getState();

        public MigrationType getType();

        public Optional<String> getChecksum();

        public String getVersion();

        public Optional<String> getOptionalDescription();

        public String getSource();

        public Optional<ZonedDateTime> getInstalledOn();

        public Optional<String> getInstalledBy();

        public Optional<Duration> getExecutionTime();

        default public Map<String, String> asMap() {
            return Map.of("version", this.getVersion(), "description", this.getOptionalDescription().orElse(""), "type", this.getType().name(), "installedOn", this.getInstalledOn().map(ZonedDateTime::toString).orElse(""), "installedBy", this.getInstalledBy().orElse(""), "executionTime", this.getExecutionTime().map(Duration::toString).orElse(""), "state", this.getState().name(), "source", this.getSource());
        }
    }

    public static enum ChainBuilderMode {
        COMPARE,
        LOCAL,
        REMOTE;

    }
}

