/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.MigrationChain;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import ac.simons.neo4j.migrations.core.MigrationsException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MigrationVersion {
    private static final String BASELINE_VALUE = "BASELINE";
    private static final MigrationVersion BASELINE = new MigrationVersion("BASELINE", null, false);
    static final String VERSION_PATTERN_BASE = "(?<type>[VR])(?<version>\\d+(?:_\\d+)*+|\\d+(?:\\.\\d+)*+)";
    static final Pattern VERSION_PATTERN = Pattern.compile("(?<type>[VR])(?<version>\\d+(?:_\\d+)*+|\\d+(?:\\.\\d+)*+)__(?<name>[\\w ]+)(?:\\.(?<ext>\\w+))?");
    static final Pattern STOP_VERSION_PATTERN = Pattern.compile("(?<type>[VR])(?<version>\\d+(?:_\\d+)*+|\\d+(?:\\.\\d+)*+)(?<op>\\?)?(__(?<name>[\\w ]+)(?:\\.(?<ext>\\w+))?)?");
    private final String value;
    private final String description;
    private final boolean repeatable;

    public static boolean canParse(String pathOrUrl) {
        return VERSION_PATTERN.matcher(pathOrUrl).find();
    }

    static MigrationVersion of(Class<?> clazz) {
        return MigrationVersion.parse(clazz.getSimpleName());
    }

    public static MigrationVersion parse(String name) {
        Matcher matcher = VERSION_PATTERN.matcher(name);
        if (!matcher.matches()) {
            throw new MigrationsException("Invalid class name for a migration: " + name);
        }
        boolean repeatable = "R".equalsIgnoreCase(matcher.group("type"));
        return new MigrationVersion(matcher.group("version").replace("_", "."), matcher.group("name").replace("_", " "), repeatable);
    }

    static Optional<StopVersion> findTargetVersion(MigrationChain chain, String value) {
        if (value == null) {
            return Optional.empty();
        }
        try {
            boolean optional;
            String upperCaseValue = value.trim().toUpperCase();
            if (!upperCaseValue.endsWith("?")) {
                optional = false;
            } else {
                optional = true;
                upperCaseValue = upperCaseValue.substring(0, upperCaseValue.length() - 1);
            }
            TargetVersion targetVersion = TargetVersion.valueOf(upperCaseValue);
            return chain.findTargetVersion(targetVersion).map(v -> new StopVersion((MigrationVersion)v, optional));
        }
        catch (IllegalArgumentException e) {
            return Optional.of(MigrationVersion.parseStopVersion(value));
        }
    }

    private static StopVersion parseStopVersion(String name) {
        Matcher matcher = STOP_VERSION_PATTERN.matcher(name);
        if (!matcher.matches()) {
            throw new MigrationsException("Invalid class or file name for a migration: " + name);
        }
        boolean repeatable = "R".equalsIgnoreCase(matcher.group("type"));
        String optionalName = matcher.group("name") == null ? "n/a" : matcher.group("name").replace("_", " ");
        return new StopVersion(new MigrationVersion(matcher.group("version").replace("_", "."), optionalName, repeatable), matcher.group("op") != null);
    }

    public static MigrationVersion withValue(String value) {
        return MigrationVersion.withValue(value, false);
    }

    static MigrationVersion withValue(String value, boolean repeatable) {
        return MigrationVersion.withValueAndDescription(value, null, repeatable);
    }

    static MigrationVersion withValueAndDescription(String value, String description, boolean repeatable) {
        if (BASELINE_VALUE.equals(value)) {
            return MigrationVersion.baseline();
        }
        return new MigrationVersion(value, description, repeatable);
    }

    static MigrationVersion baseline() {
        return BASELINE;
    }

    private MigrationVersion(String value, String description, boolean repeatable) {
        this.value = value;
        this.description = description;
        this.repeatable = repeatable;
    }

    public String getValue() {
        return this.value;
    }

    boolean isRepeatable() {
        return this.repeatable;
    }

    Optional<String> getOptionalDescription() {
        return Optional.ofNullable(this.description);
    }

    public String toString() {
        return this.getValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationVersion that = (MigrationVersion)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    static Comparator<MigrationVersion> getComparator(MigrationsConfig.VersionSortOrder versionSortOrder) {
        return switch (versionSortOrder) {
            default -> throw new IncompatibleClassChangeError();
            case MigrationsConfig.VersionSortOrder.LEXICOGRAPHIC -> new VersionComparator();
            case MigrationsConfig.VersionSortOrder.SEMANTIC -> new SemanticVersionComparator();
        };
    }

    public static enum TargetVersion {
        CURRENT,
        LATEST,
        NEXT;

    }

    record StopVersion(MigrationVersion version, boolean optional) {
    }

    private static class VersionComparator
    implements Comparator<MigrationVersion> {
        private VersionComparator() {
        }

        @Override
        public int compare(MigrationVersion o1, MigrationVersion o2) {
            if (o1 == MigrationVersion.baseline() && o2 == MigrationVersion.baseline()) {
                return 0;
            }
            if (o1 == MigrationVersion.baseline() || o2 == MigrationVersion.baseline()) {
                return 1;
            }
            return o1.getValue().compareTo(o2.getValue());
        }
    }

    private static class SemanticVersionComparator
    implements Comparator<MigrationVersion> {
        private SemanticVersionComparator() {
        }

        @Override
        public int compare(MigrationVersion o1, MigrationVersion o2) {
            int i;
            if (o1 == MigrationVersion.baseline() && o2 == MigrationVersion.baseline()) {
                return 0;
            }
            if (o1 == MigrationVersion.baseline() || o2 == MigrationVersion.baseline()) {
                return 1;
            }
            Long[] lhs = (Long[])Arrays.stream(o1.value.split("\\.")).map(Long::parseLong).toArray(Long[]::new);
            Long[] rhs = (Long[])Arrays.stream(o2.value.split("\\.")).map(Long::parseLong).toArray(Long[]::new);
            int max = Math.min(lhs.length, rhs.length);
            for (i = 0; i < max; ++i) {
                int result = Long.compare(lhs[i], rhs[i]);
                if (result == 0) continue;
                return result;
            }
            if (lhs.length < rhs.length) {
                return rhs[i] == 0L ? 0 : -1;
            }
            if (lhs.length > rhs.length) {
                return lhs[i] == 0L ? 0 : 1;
            }
            return 0;
        }
    }
}

