/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.ClasspathResourceScanner;
import ac.simons.neo4j.migrations.core.DefaultClasspathResourceScanner;
import ac.simons.neo4j.migrations.core.Defaults;
import ac.simons.neo4j.migrations.core.Discoverer;
import ac.simons.neo4j.migrations.core.JavaBasedMigration;
import ac.simons.neo4j.migrations.core.JavaBasedMigrationDiscoverer;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import ac.simons.neo4j.migrations.core.catalog.RenderConfig;
import ac.simons.neo4j.migrations.core.internal.Strings;
import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.driver.Session;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.summary.DatabaseInfo;
import org.neo4j.driver.summary.ResultSummary;

public final class MigrationsConfig {
    private final String[] packagesToScan;
    private final String[] locationsToScan;
    private final TransactionMode transactionMode;
    private final String database;
    private final String schemaDatabase;
    private final String impersonatedUser;
    private final String installedBy;
    private final boolean validateOnMigrate;
    private final boolean autocrlf;
    private final Discoverer<JavaBasedMigration> migrationClassesDiscoverer;
    private final ClasspathResourceScanner resourceScanner;
    private final Duration delayBetweenMigrations;
    private final List<? extends RenderConfig.AdditionalRenderingOptions> constraintOptions;
    private final VersionSortOrder versionSortOrder;
    private final Duration transactionTimeout;
    private final boolean outOfOrder;
    private final String target;
    private final boolean useFlywayCompatibleChecksums;

    public static Builder builder() {
        return new Builder();
    }

    public static MigrationsConfig defaultConfig() {
        return MigrationsConfig.builder().build();
    }

    private MigrationsConfig(Builder builder) {
        this.packagesToScan = builder.packagesToScan == null ? Defaults.PACKAGES_TO_SCAN.toArray(new String[0]) : builder.packagesToScan;
        this.locationsToScan = builder.locationsToScan == null ? Defaults.LOCATIONS_TO_SCAN.toArray(new String[0]) : builder.locationsToScan;
        this.transactionMode = Optional.ofNullable(builder.transactionMode).orElse(TransactionMode.PER_MIGRATION);
        this.database = builder.database;
        this.impersonatedUser = builder.impersonatedUser;
        this.installedBy = Optional.ofNullable(builder.installedBy).orElse(System.getProperty("user.name"));
        this.validateOnMigrate = builder.validateOnMigrate;
        this.autocrlf = builder.autocrlf;
        this.migrationClassesDiscoverer = builder.migrationClassesDiscoverer == null ? new JavaBasedMigrationDiscoverer() : builder.migrationClassesDiscoverer;
        this.resourceScanner = builder.resourceScanner == null ? new DefaultClasspathResourceScanner() : builder.resourceScanner;
        this.schemaDatabase = builder.schemaDatabase;
        this.delayBetweenMigrations = builder.delayBetweenMigrations;
        this.constraintOptions = builder.constraintOptions;
        this.versionSortOrder = builder.versionSortOrder;
        this.transactionTimeout = builder.transactionTimeout;
        this.outOfOrder = builder.outOfOrder;
        this.useFlywayCompatibleChecksums = builder.useFlywayCompatibleChecksums;
        this.target = builder.target == null || builder.target.isBlank() ? null : builder.target;
    }

    public String[] getPackagesToScan() {
        return this.packagesToScan;
    }

    public String[] getLocationsToScan() {
        return this.locationsToScan;
    }

    public TransactionMode getTransactionMode() {
        return this.transactionMode;
    }

    public Optional<String> getOptionalDatabase() {
        return Strings.optionalOf(this.database);
    }

    public Optional<String> getOptionalSchemaDatabase() {
        return Strings.optionalOf(this.schemaDatabase);
    }

    public Optional<String> getOptionalImpersonatedUser() {
        return Strings.optionalOf(this.impersonatedUser);
    }

    public Optional<String> getOptionalInstalledBy() {
        return Strings.optionalOf(this.installedBy);
    }

    public boolean isValidateOnMigrate() {
        return this.validateOnMigrate;
    }

    public boolean isAutocrlf() {
        return this.autocrlf;
    }

    public Discoverer<JavaBasedMigration> getMigrationClassesDiscoverer() {
        return this.migrationClassesDiscoverer;
    }

    public ClasspathResourceScanner getResourceScanner() {
        return this.resourceScanner;
    }

    public Optional<Duration> getOptionalDelayBetweenMigrations() {
        return Optional.ofNullable(this.delayBetweenMigrations);
    }

    public List<? extends RenderConfig.AdditionalRenderingOptions> getConstraintRenderingOptions() {
        return List.copyOf(this.constraintOptions);
    }

    public Duration getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public boolean isOutOfOrder() {
        return this.outOfOrder;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isUseFlywayCompatibleChecksums() {
        return this.useFlywayCompatibleChecksums;
    }

    public void logTo(Logger logger, boolean verbose) {
        if (!this.hasPlacesToLookForMigrations()) {
            logger.log(Level.WARNING, "Cannot find migrations as neither locations nor packages to scan are configured!");
        }
        if (verbose && logger.isLoggable(Level.INFO)) {
            this.getOptionalDatabase().ifPresent(v -> logger.log(Level.INFO, "Migrations will be applied to database \"{0}\"", v));
            if (this.getLocationsToScan().length > 0) {
                logger.log(Level.INFO, "Will search for Cypher scripts in \"{0}\"", String.join((CharSequence)"", this.getLocationsToScan()));
                logger.log(Level.INFO, "Statements will be applied {0}", this.getTransactionMode() == TransactionMode.PER_MIGRATION ? "in one transaction per migration" : "in separate transactions");
            }
            if (this.getPackagesToScan().length > 0) {
                logger.log(Level.INFO, "Will scan for Java-based migrations in \"{0}\"", String.join((CharSequence)"", this.getPackagesToScan()));
            }
        }
    }

    boolean hasPlacesToLookForMigrations() {
        return this.getPackagesToScan().length > 0 || this.getLocationsToScan().length > 0;
    }

    Optional<String> getMigrationTargetIn(MigrationContext context) {
        Optional<String> optionalDatabase = this.getOptionalDatabase();
        Optional<String> optionalSchemaDatabase = this.getOptionalSchemaDatabase();
        if (optionalSchemaDatabase.isEmpty()) {
            return Optional.empty();
        }
        if (optionalDatabase.isEmpty()) {
            try (Session session = context.getSession();){
                try {
                    optionalDatabase = Optional.of((String)session.executeRead(tx -> tx.run("CALL db.info() YIELD name").single().get("name").asString()));
                }
                catch (ClientException e) {
                    optionalDatabase = Optional.ofNullable(((ResultSummary)session.executeRead(tx -> tx.run("MATCH (n) RETURN count(n)").consume())).database()).map(DatabaseInfo::name);
                }
            }
        }
        if (!optionalDatabase.equals(optionalSchemaDatabase)) {
            return optionalDatabase.map(s -> s.toLowerCase(Locale.ROOT));
        }
        return Optional.empty();
    }

    public VersionSortOrder getVersionSortOrder() {
        return this.versionSortOrder;
    }

    Comparator<MigrationVersion> getVersionComparator() {
        return MigrationVersion.getComparator(this.versionSortOrder);
    }

    public static class Builder {
        private String[] packagesToScan;
        private String[] locationsToScan;
        private TransactionMode transactionMode;
        private String database;
        private String impersonatedUser;
        private String installedBy;
        private boolean validateOnMigrate = true;
        private boolean autocrlf = false;
        private String schemaDatabase;
        private Discoverer<JavaBasedMigration> migrationClassesDiscoverer;
        private ClasspathResourceScanner resourceScanner;
        private Duration delayBetweenMigrations;
        private List<? extends RenderConfig.AdditionalRenderingOptions> constraintOptions = List.of();
        private VersionSortOrder versionSortOrder = Defaults.VERSION_SORT_ORDER;
        private Duration transactionTimeout;
        private boolean outOfOrder = false;
        private String target;
        private boolean useFlywayCompatibleChecksums = false;

        private Builder() {
        }

        public Builder withPackagesToScan(String ... packages) {
            this.packagesToScan = packages;
            return this;
        }

        public Builder withLocationsToScan(String ... locations) {
            this.locationsToScan = locations;
            return this;
        }

        public Builder withTransactionMode(TransactionMode newTransactionMode) {
            this.transactionMode = newTransactionMode;
            return this;
        }

        public Builder withDatabase(String newDatabase) {
            this.database = newDatabase;
            return this;
        }

        public Builder withInstalledBy(String newInstalledBy) {
            this.installedBy = newInstalledBy;
            return this;
        }

        public Builder withValidateOnMigrate(boolean newValidateOnMigrate) {
            this.validateOnMigrate = newValidateOnMigrate;
            return this;
        }

        public Builder withAutocrlf(boolean newAutocrlf) {
            this.autocrlf = newAutocrlf;
            return this;
        }

        public Builder withImpersonatedUser(String newImpersonatedUser) {
            this.impersonatedUser = newImpersonatedUser;
            return this;
        }

        public Builder withSchemaDatabase(String newSchemaDatabase) {
            this.schemaDatabase = newSchemaDatabase;
            return this;
        }

        public Builder withMigrationClassesDiscoverer(Discoverer<JavaBasedMigration> newMigrationClassesDiscoverer) {
            this.migrationClassesDiscoverer = newMigrationClassesDiscoverer;
            return this;
        }

        public Builder withResourceScanner(ClasspathResourceScanner newResourceScanner) {
            this.resourceScanner = newResourceScanner;
            return this;
        }

        public Builder withDelayBetweenMigrations(Duration newDelayBetweenMigrations) {
            this.delayBetweenMigrations = newDelayBetweenMigrations;
            return this;
        }

        public Builder withConstraintRenderingOptions(Collection<? extends RenderConfig.AdditionalRenderingOptions> newRenderingOptions) {
            this.constraintOptions = List.copyOf(Objects.requireNonNullElseGet(newRenderingOptions, List::of));
            return this;
        }

        public Builder withVersionSortOrder(VersionSortOrder newVersionSortOrder) {
            this.versionSortOrder = newVersionSortOrder;
            return this;
        }

        public Builder withTransactionTimeout(Duration newTransactionTimeout) {
            this.transactionTimeout = newTransactionTimeout;
            return this;
        }

        public Builder withOutOfOrderAllowed(boolean allowed) {
            this.outOfOrder = allowed;
            return this;
        }

        public Builder withTarget(String newTarget) {
            this.target = newTarget;
            return this;
        }

        public Builder withFlywayCompatibleChecksums(boolean enabled) {
            this.useFlywayCompatibleChecksums = enabled;
            return this;
        }

        public MigrationsConfig build() {
            return new MigrationsConfig(this);
        }
    }

    public static enum TransactionMode {
        PER_MIGRATION,
        PER_STATEMENT;

    }

    public static enum VersionSortOrder {
        LEXICOGRAPHIC,
        SEMANTIC;

    }
}

