/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.Migrations;
import ac.simons.neo4j.migrations.core.MigrationsException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

final class ProductVersion {
    private static volatile String value;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getValue() {
        String computedVersion = value;
        if (computedVersion != null) return computedVersion;
        Class<ProductVersion> clazz = ProductVersion.class;
        synchronized (ProductVersion.class) {
            computedVersion = value;
            if (computedVersion != null) return computedVersion;
            value = ProductVersion.getVersionImpl();
            return value;
        }
    }

    private static String getVersionImpl() {
        try {
            Enumeration<URL> resources = Migrations.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Manifest manifest = new Manifest(url.openStream());
                if (!ProductVersion.isApplicableManifest(manifest)) continue;
                Attributes attr = manifest.getMainAttributes();
                return ProductVersion.get(attr, "Implementation-Version").toString();
            }
        }
        catch (IOException ex) {
            throw new MigrationsException("Unable to read from neo4j-migrations-core manifest.");
        }
        return "unknown";
    }

    private static boolean isApplicableManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        return "neo4j-migrations".equals(ProductVersion.get(attributes, "Artifact-Id"));
    }

    private static Object get(Attributes attributes, String key) {
        return attributes.get(new Attributes.Name(key));
    }

    private ProductVersion() {
    }
}

