/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.Defaults;
import ac.simons.neo4j.migrations.core.Migrations;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import ac.simons.neo4j.migrations.core.MigrationsException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;

public final class ResourceContext {
    private final URL url;
    private final MigrationsConfig config;

    public static ResourceContext of(URL url, MigrationsConfig config) {
        return new ResourceContext(url, config);
    }

    static ResourceContext of(URL url) {
        return ResourceContext.of(url, MigrationsConfig.builder().withAutocrlf(false).build());
    }

    private ResourceContext(URL url, MigrationsConfig config) {
        this.url = url;
        this.config = config;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getIdentifier() {
        return ResourceContext.generateIdentifierOf(this.url);
    }

    static String generateIdentifierOf(URL url) {
        String path = url.getPath();
        try {
            path = URLDecoder.decode(path, Defaults.CYPHER_SCRIPT_ENCODING.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new MigrationsException("Somethings broken: UTF-8 encoding not supported.");
        }
        int lastIndexOf = path.lastIndexOf("/");
        return lastIndexOf < 0 ? path : path.substring(lastIndexOf + 1);
    }

    public MigrationsConfig getConfig() {
        return this.config;
    }

    public InputStream openStream() {
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            String oldUrl = this.url.toString();
            if (e instanceof FileNotFoundException && oldUrl.contains("jar:file") && oldUrl.contains("!/BOOT-INF/")) {
                String newUrl = oldUrl.replace("jar:file", "jar:nested").replace("!/BOOT-INF/", "/!BOOT-INF/");
                Migrations.LOGGER.log(Level.FINE, "Probably on Spring Boot >= 3.2.0 with new Jar loader, replacing {0} with {1}", new Object[]{oldUrl, newUrl});
                try {
                    return URI.create(newUrl).toURL().openStream();
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            throw new UncheckedIOException(e);
        }
    }
}

