/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.AggregatingMigrationDiscoverer;
import ac.simons.neo4j.migrations.core.Callback;
import ac.simons.neo4j.migrations.core.ClasspathResourceScanner;
import ac.simons.neo4j.migrations.core.CypherBasedCallback;
import ac.simons.neo4j.migrations.core.Defaults;
import ac.simons.neo4j.migrations.core.Discoverer;
import ac.simons.neo4j.migrations.core.LifecyclePhase;
import ac.simons.neo4j.migrations.core.Location;
import ac.simons.neo4j.migrations.core.Migration;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import ac.simons.neo4j.migrations.core.ResourceBasedMigrationProvider;
import ac.simons.neo4j.migrations.core.ResourceContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

final class ResourceDiscoverer<T>
implements Discoverer<T> {
    private static final Logger LOGGER = Logger.getLogger(ResourceDiscoverer.class.getName());
    private final ClasspathResourceScanner scanner;
    private final Predicate<String> resourceFilter;
    private final Function<ResourceContext, Collection<T>> mapper;

    static Discoverer<Migration> forMigrations(ClasspathResourceScanner resourceScanner) {
        ArrayList<Discoverer<Migration>> allDiscovers = new ArrayList<Discoverer<Migration>>();
        for (ResourceBasedMigrationProvider provider : ResourceBasedMigrationProvider.unique()) {
            Predicate<String> filter = pathOrUrl -> {
                String path = URLDecoder.decode(pathOrUrl, Defaults.CYPHER_SCRIPT_ENCODING);
                if (provider.supportsArbitraryResourceNames()) {
                    return path.endsWith(provider.getExtension());
                }
                Matcher matcher = MigrationVersion.VERSION_PATTERN.matcher(path);
                boolean isValidResource = matcher.find();
                if (!isValidResource && LOGGER.isLoggable(Level.FINE) && !LifecyclePhase.canParse(path)) {
                    LOGGER.log(Level.FINE, "Skipping resource {0}", path);
                }
                return isValidResource && provider.getExtension().equals(matcher.group("ext"));
            };
            allDiscovers.add(new ResourceDiscoverer(resourceScanner, filter, provider::handle));
        }
        return new AggregatingMigrationDiscoverer(allDiscovers);
    }

    static ResourceDiscoverer<Callback> forCallbacks(ClasspathResourceScanner resourceScanner) {
        Predicate<String> filter = LifecyclePhase::canParse;
        filter = filter.and(fullPath -> {
            int lastSlashIdx = fullPath.lastIndexOf(47);
            int lastDotIdx = fullPath.lastIndexOf(46);
            return lastDotIdx > lastSlashIdx && fullPath.substring(lastDotIdx + 1).equalsIgnoreCase("cypher");
        });
        return new ResourceDiscoverer<Callback>(resourceScanner, filter, ctx -> Collections.singletonList(new CypherBasedCallback((ResourceContext)ctx)));
    }

    private ResourceDiscoverer(ClasspathResourceScanner scanner, Predicate<String> resourceFilter, Function<ResourceContext, Collection<T>> mapper) {
        this.scanner = scanner;
        this.resourceFilter = resourceFilter;
        this.mapper = mapper;
    }

    @Override
    public Collection<T> discover(MigrationContext context) {
        MigrationsConfig config = context.getConfig();
        ArrayList<T> listOfMigrations = new ArrayList<T>();
        ArrayList<String> classpathLocations = new ArrayList<String>();
        ArrayList<URI> filesystemLocations = new ArrayList<URI>();
        for (String prefixAndLocation : config.getLocationsToScan()) {
            Location location = Location.of(prefixAndLocation);
            if (location.getType() == Location.LocationType.CLASSPATH) {
                classpathLocations.add(location.getName());
                continue;
            }
            if (location.getType() != Location.LocationType.FILESYSTEM) continue;
            filesystemLocations.add(location.toUri());
        }
        listOfMigrations.addAll(this.scanClasspathLocations(classpathLocations, context.getConfig()));
        listOfMigrations.addAll(this.scanFilesystemLocations(filesystemLocations, context.getConfig()));
        return listOfMigrations;
    }

    private List<T> scanClasspathLocations(List<String> classpathLocations, MigrationsConfig config) {
        if (classpathLocations.isEmpty()) {
            return Collections.emptyList();
        }
        LOGGER.log(Level.FINE, "Scanning for classpath resources in {0}", classpathLocations);
        return this.scanner.scan(classpathLocations).stream().filter(r -> this.resourceFilter.test(r.getPath())).map(resource -> ResourceContext.of(resource, config)).map(this.mapper).flatMap(Collection::stream).toList();
    }

    private List<T> scanFilesystemLocations(List<URI> filesystemLocations, final MigrationsConfig config) {
        if (filesystemLocations.isEmpty()) {
            return Collections.emptyList();
        }
        LOGGER.log(Level.FINE, "Scanning for filesystem resources in {0}", filesystemLocations);
        final ArrayList resources = new ArrayList();
        for (URI location : filesystemLocations) {
            Path path = Paths.get(location);
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            try {
                Files.walkFileTree(path, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String fullPath = file.toString();
                        if (attrs.isRegularFile() && ResourceDiscoverer.this.resourceFilter.test(fullPath)) {
                            ResourceContext context = ResourceContext.of(file.toFile().toURI().toURL(), config);
                            resources.addAll(ResourceDiscoverer.this.mapper.apply(context));
                            return FileVisitResult.CONTINUE;
                        }
                        return super.visitFile(file, attrs);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return resources;
    }
}

