/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.catalog;

import ac.simons.neo4j.migrations.core.catalog.CatalogItem;
import ac.simons.neo4j.migrations.core.catalog.Constraint;
import ac.simons.neo4j.migrations.core.catalog.GeneratedName;
import ac.simons.neo4j.migrations.core.catalog.Index;
import ac.simons.neo4j.migrations.core.catalog.ItemType;
import ac.simons.neo4j.migrations.core.catalog.Name;
import ac.simons.neo4j.migrations.core.catalog.TargetEntityType;
import ac.simons.neo4j.migrations.core.internal.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

abstract class AbstractCatalogItem<T extends ItemType>
implements CatalogItem<T> {
    private final Name name;
    private final T type;
    private final TargetEntityType targetEntityType;
    private final String identifier;
    private final Set<String> properties;
    protected final String options;

    static Optional<String> resolveOptions(MapAccessor row) {
        if (!row.containsKey("options")) {
            return Optional.empty();
        }
        Value options = row.get("options");
        if (options.isNull() || options.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(AbstractCatalogItem.renderMap(options));
    }

    private static String renderMap(Value value) {
        if (TypeSystem.getDefault().MAP().isTypeOf(value)) {
            Map map = value.asMap(Function.identity());
            return map.entrySet().stream().map(e -> String.format("`%s`: %s", e.getKey(), AbstractCatalogItem.renderMap((Value)e.getValue()))).collect(Collectors.joining(", ", "{", "}"));
        }
        if (TypeSystem.getDefault().LIST().isTypeOf(value)) {
            List list = value.asList(Function.identity());
            return list.stream().map(AbstractCatalogItem::renderMap).collect(Collectors.joining(", ", "[", "]"));
        }
        return value.toString();
    }

    AbstractCatalogItem(String name, T type, TargetEntityType targetEntityType, String identifier, Collection<String> properties, String options) {
        if (properties.isEmpty() && type != Index.Type.LOOKUP) {
            throw new IllegalArgumentException("Constraints or indices require one or more properties.");
        }
        this.type = type;
        this.targetEntityType = targetEntityType;
        this.identifier = identifier;
        this.properties = new LinkedHashSet<String>(properties);
        this.options = options;
        this.name = Strings.isBlank(name) ? Name.generate(this.getClass(), type, targetEntityType, identifier, properties, options) : Name.of(name);
    }

    @Override
    public final Name getName() {
        return this.name;
    }

    boolean hasName() {
        return !(this.name instanceof GeneratedName);
    }

    @Override
    public T getType() {
        return this.type;
    }

    public TargetEntityType getTargetEntityType() {
        return this.targetEntityType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Set<String> getProperties() {
        return this.properties;
    }

    public Optional<String> getOptionalOptions() {
        return Strings.optionalOf(this.options);
    }

    @Override
    public final boolean hasGeneratedName() {
        return this.getName() instanceof GeneratedName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCatalogItem that = (AbstractCatalogItem)o;
        return this.getName().equals(that.getName()) && this.getOptionalOptions().equals(that.getOptionalOptions()) && this.isEquivalentTo(that);
    }

    static Target extractTarget(Element element) {
        TargetEntityType targetEntityType;
        NodeList labelOrType = element.getElementsByTagName("label");
        if (labelOrType.getLength() == 0) {
            labelOrType = element.getElementsByTagName("type");
            targetEntityType = TargetEntityType.RELATIONSHIP;
        } else {
            targetEntityType = TargetEntityType.NODE;
        }
        return new Target(labelOrType.item(0).getTextContent(), targetEntityType);
    }

    static Set<String> extractProperties(Element element) {
        NodeList propertyNodes = ((Element)element.getElementsByTagName("properties").item(0)).getElementsByTagName("property");
        LinkedHashSet<String> properties = new LinkedHashSet<String>();
        for (int i = 0; i < propertyNodes.getLength(); ++i) {
            properties.add(propertyNodes.item(i).getTextContent());
        }
        return properties;
    }

    static String extractOptions(Element constraintElement) {
        NodeList optionsElement = constraintElement.getElementsByTagName("options");
        String options = null;
        if (optionsElement.getLength() == 1) {
            options = Arrays.stream(optionsElement.item(0).getTextContent().split("\r?\n")).map(String::trim).collect(Collectors.joining("\n"));
        }
        return options;
    }

    final Element toXML(Document document) {
        String labelOrTypeContent;
        String elementName;
        if (this instanceof Constraint) {
            elementName = "constraint";
            labelOrTypeContent = this.getIdentifier();
        } else {
            AbstractCatalogItem abstractCatalogItem = this;
            if (abstractCatalogItem instanceof Index) {
                Index index = (Index)abstractCatalogItem;
                elementName = "index";
                labelOrTypeContent = index.getDeconstructedIdentifiers().stream().map(s -> s.replace("|", "\\|")).collect(Collectors.joining("|"));
            } else {
                throw new IllegalStateException("Unsupported subclass " + String.valueOf(this.getClass()));
            }
        }
        Element element = document.createElement(elementName);
        element.setAttribute("name", this.getName().getValue());
        element.setIdAttribute("name", true);
        element.setAttribute("type", this.getType().getName());
        Element labelOrType = this.getTargetEntityType() == TargetEntityType.NODE ? document.createElement("label") : document.createElement("type");
        labelOrType.setTextContent(labelOrTypeContent);
        element.appendChild(labelOrType);
        Element propertiesParentElement = document.createElement("properties");
        for (String propertyValue : this.getProperties()) {
            Constraint constraint;
            Element newElement = document.createElement("property");
            newElement.setTextContent(propertyValue);
            AbstractCatalogItem abstractCatalogItem = this;
            if (abstractCatalogItem instanceof Constraint && (constraint = (Constraint)abstractCatalogItem).getType() == Constraint.Type.PROPERTY_TYPE) {
                newElement.setAttribute("type", constraint.getPropertyType().getName());
            }
            propertiesParentElement.appendChild(newElement);
        }
        element.appendChild(propertiesParentElement);
        this.getOptionalOptions().ifPresent(optionsValue -> {
            Element newElement = document.createElement("options");
            newElement.setTextContent((String)optionsValue);
            element.appendChild(newElement);
        });
        return element;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getType(), this.getTargetEntityType(), this.getIdentifier(), this.getProperties(), this.getOptionalOptions()});
    }

    record Target(String identifier, TargetEntityType targetEntityType) {
    }
}

