/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.catalog;

import ac.simons.neo4j.migrations.core.catalog.AbstractCatalogItem;
import ac.simons.neo4j.migrations.core.catalog.CatalogItem;
import ac.simons.neo4j.migrations.core.catalog.ItemType;
import ac.simons.neo4j.migrations.core.catalog.TargetEntityType;
import ac.simons.neo4j.migrations.core.internal.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.MapAccessor;
import org.w3c.dom.Element;

public final class Index
extends AbstractCatalogItem<Type> {
    private static final String PROVIDER_PATTERN_FMT = "(?i)`?indexProvider`?\\s*:\\s*(['\"])%s-\\d\\.0(['\"])";
    private static final Pattern PROVIDER_PATTERN_RANGE = Pattern.compile(String.format("(?i)`?indexProvider`?\\s*:\\s*(['\"])%s-\\d\\.0(['\"])", "range"));
    private static final Pattern PROVIDER_PATTERN_BTREE = Pattern.compile(String.format("(?i)`?indexProvider`?\\s*:\\s*(['\"])%s-\\d\\.0(['\"])", "native-btree"));
    private static final String TOKEN_NAMES = "tokenNames";
    private static final String LABELS_OR_TYPES = "labelsOrTypes";
    private static final String[] NAME_KEYS = new String[]{"indexName", "name"};
    private static final String PROPERTIES_KEY = "properties";
    private static final String ENTITY_TYPE_KEY = "entityType";
    private static final String INDEX_TYPE_KEY = "type";
    private static final String UNIQUENESS_KEY = "uniqueness";
    private static final String OWNING_CONSTRAINT_KEY = "owningConstraint";
    private static final UnaryOperator<String> UNESCAPE_PIPE = s -> s.replace("\\|", "|");
    private static final Set<String> REQUIRED_KEYS_35 = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(NAME_KEYS[0], "type", "tokenNames", "properties")));
    private static final Set<String> REQUIRED_KEYS_40 = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(NAME_KEYS[1], "type", "entityType", "labelsOrTypes", "properties")));
    private final Set<String> deconstructedIdentifiers;

    public static Builder forNode(String label) {
        return new DefaultBuilder(TargetEntityType.NODE, new String[]{label});
    }

    public static FulltextBuilder forNode(String ... labels) {
        return new DefaultBuilder(TargetEntityType.NODE, labels);
    }

    public static Builder forRelationship(String type) {
        return new DefaultBuilder(TargetEntityType.RELATIONSHIP, new String[]{type});
    }

    public static FulltextBuilder forRelationship(String ... types) {
        return new DefaultBuilder(TargetEntityType.RELATIONSHIP, types);
    }

    public static Index parse(Element indexElement) {
        String name = indexElement.getAttribute("name");
        String typeValue = indexElement.getAttribute(INDEX_TYPE_KEY);
        Type type = Strings.isBlank(typeValue) ? Type.PROPERTY : Type.valueOf(typeValue.toUpperCase(Locale.ROOT));
        AbstractCatalogItem.Target target = Index.extractTarget(indexElement);
        Set<String> properties = Index.extractProperties(indexElement);
        String options = Index.extractOptions(indexElement);
        String at = "(?<!\\\\)\\|";
        return new Index(name, type, target.targetEntityType(), Arrays.asList(target.identifier().split(at)), new LinkedHashSet<String>(properties), options);
    }

    public static Index parse(MapAccessor row) {
        Value columnOfInterest;
        if (!REQUIRED_KEYS_35.stream().allMatch(arg_0 -> ((MapAccessor)row).containsKey(arg_0))) {
            if (!REQUIRED_KEYS_40.stream().allMatch(arg_0 -> ((MapAccessor)row).containsKey(arg_0))) {
                throw new IllegalArgumentException("Required keys are missing in the row describing the index");
            }
        }
        List labelsOrTypes = row.get(TOKEN_NAMES).isNull() ? ((columnOfInterest = row.get(LABELS_OR_TYPES)).isNull() ? Collections.emptyList() : columnOfInterest.asList(Value::asString)) : row.get(TOKEN_NAMES).asList(Value::asString);
        String name = !row.get(NAME_KEYS[0]).isNull() ? row.get(NAME_KEYS[0]).asString() : row.get(NAME_KEYS[1]).asString();
        String indexType = row.get(INDEX_TYPE_KEY).asString();
        String entityType = !row.get(ENTITY_TYPE_KEY).isNull() ? row.get(ENTITY_TYPE_KEY).asString() : "NODE";
        List properties = row.get(PROPERTIES_KEY).isNull() ? Collections.emptyList() : row.get(PROPERTIES_KEY).asList(Value::asString);
        TargetEntityType targetEntityType = TargetEntityType.valueOf(entityType);
        Type type = switch (indexType) {
            case "LOOKUP" -> Type.LOOKUP;
            case "node_label_property", "BTREE", "RANGE" -> Type.PROPERTY;
            case "FULLTEXT", "node_fulltext" -> Type.FULLTEXT;
            case "node_unique_property" -> Type.CONSTRAINT_BACKING_INDEX;
            case "VECTOR" -> Type.VECTOR;
            default -> throw new IllegalArgumentException("Unsupported index type " + name);
        };
        if (Index.isConstraintBackingIndex(row)) {
            type = Type.CONSTRAINT_BACKING_INDEX;
        }
        String options = Index.resolveOptions(row).orElse(null);
        return new Index(name, type, targetEntityType, labelsOrTypes, new LinkedHashSet<String>(properties), options);
    }

    static boolean isConstraintBackingIndex(MapAccessor row) {
        return !row.get(UNIQUENESS_KEY).isNull() && row.get(UNIQUENESS_KEY).asString().equals("UNIQUE") || !row.get(OWNING_CONSTRAINT_KEY).isNull();
    }

    Index(String name, Type type, TargetEntityType targetEntityType, Collection<String> deconstructedIdentifiers, Collection<String> properties) {
        this(name, type, targetEntityType, deconstructedIdentifiers, properties, null);
    }

    Index(String name, Type type, TargetEntityType targetEntityType, Collection<String> deconstructedIdentifiers, Collection<String> properties, String options) {
        super(name, type, targetEntityType, Index.join(deconstructedIdentifiers), properties, options);
        if (deconstructedIdentifiers.size() > 1 && type != Type.FULLTEXT) {
            throw new IllegalArgumentException("Multiple labels or types are only allowed to be specified with fulltext indexes.");
        }
        if (properties.size() > 1 && type == Type.TEXT) {
            throw new IllegalArgumentException("Text indexes only allow exactly one single property.");
        }
        this.deconstructedIdentifiers = deconstructedIdentifiers.stream().map(UNESCAPE_PIPE).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static String join(Collection<String> deconstructedIdentifiers) {
        return deconstructedIdentifiers.stream().map(UNESCAPE_PIPE).collect(Collectors.joining(", ", "[", "]"));
    }

    public String toString() {
        return this.getName().getValue() + String.valueOf(this.getType()) + this.getIdentifier();
    }

    public Index withName(String newName) {
        if (Objects.equals(super.getName().getValue(), newName)) {
            return this;
        }
        return new Index(newName, (Type)this.getType(), this.getTargetEntityType(), this.getDeconstructedIdentifiers(), (Collection<String>)this.getProperties(), this.options);
    }

    public Index withOptions(String newOptions) {
        if (Objects.equals(this.options, newOptions)) {
            return this;
        }
        return new Index(this.getName().getValue(), (Type)this.getType(), this.getTargetEntityType(), this.getDeconstructedIdentifiers(), (Collection<String>)this.getProperties(), newOptions);
    }

    public Index withType(Type newType) {
        if (Objects.equals(this.getType(), newType)) {
            return this;
        }
        return new Index(this.getName().getValue(), newType, this.getTargetEntityType(), this.getDeconstructedIdentifiers(), (Collection<String>)this.getProperties(), this.options);
    }

    @Override
    public boolean isEquivalentTo(CatalogItem<?> that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Index)) {
            return false;
        }
        Index other = (Index)that;
        return ((Type)this.getType()).equals(other.getType()) && this.getTargetEntityType().equals((Object)other.getTargetEntityType()) && this.getIdentifier().equals(other.getIdentifier()) && this.getProperties().equals(other.getProperties());
    }

    Collection<String> getDeconstructedIdentifiers() {
        return Collections.unmodifiableSet(this.deconstructedIdentifiers);
    }

    boolean isRangePropertyIndex() {
        return this.isPropertyIndexMatching(PROVIDER_PATTERN_RANGE);
    }

    boolean isBtreePropertyIndex() {
        return this.isPropertyIndexMatching(PROVIDER_PATTERN_BTREE);
    }

    private boolean isPropertyIndexMatching(Pattern pattern) {
        return this.getType() == Type.PROPERTY && this.getOptionalOptions().filter(pattern.asPredicate()).isPresent();
    }

    private static class DefaultBuilder
    implements Builder,
    FulltextBuilder,
    NamedSingleIdentifierBuilder,
    NamedFulltextBuilder {
        private final TargetEntityType targetEntity;
        private final String[] identifiers;
        private String name;

        private DefaultBuilder(TargetEntityType targetEntity, String[] identifiers) {
            this.targetEntity = targetEntity;
            this.identifiers = identifiers;
        }

        @Override
        public DefaultBuilder named(String newName) {
            this.name = newName;
            return this;
        }

        @Override
        public Index onProperties(String ... properties) {
            return this.makeIndex(properties, Type.PROPERTY);
        }

        @Override
        public Index text(String property) {
            return this.makeIndex(new String[]{property}, Type.TEXT);
        }

        @Override
        public Index fulltext(String ... properties) {
            return this.makeIndex(properties, Type.FULLTEXT);
        }

        private Index makeIndex(String[] properties, Type text) {
            return new Index(this.name, text, this.targetEntity, Arrays.asList(this.identifiers), Arrays.asList(properties));
        }
    }

    public static enum Type implements ItemType
    {
        PROPERTY,
        LOOKUP,
        FULLTEXT,
        TEXT,
        POINT,
        CONSTRAINT_BACKING_INDEX,
        VECTOR;


        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static interface NamedFulltextBuilder
    extends NamedBuilder {
        public Index fulltext(String ... var1);
    }

    public static interface NamedSingleIdentifierBuilder
    extends NamedFulltextBuilder {
        public Index onProperties(String ... var1);

        public Index text(String var1);
    }

    public static interface NamedBuilder {
    }

    public static interface FulltextBuilder {
        public NamedFulltextBuilder named(String var1);
    }

    public static interface Builder {
        public NamedSingleIdentifierBuilder named(String var1);
    }
}

