/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.catalog;

import ac.simons.neo4j.migrations.core.Neo4jVersion;
import ac.simons.neo4j.migrations.core.catalog.AnonymousCatalogItem;
import ac.simons.neo4j.migrations.core.catalog.CypherRenderingUtils;
import ac.simons.neo4j.migrations.core.catalog.FormattableCatalogItem;
import ac.simons.neo4j.migrations.core.catalog.Index;
import ac.simons.neo4j.migrations.core.catalog.Operator;
import ac.simons.neo4j.migrations.core.catalog.RenderConfig;
import ac.simons.neo4j.migrations.core.catalog.Renderer;
import ac.simons.neo4j.migrations.core.catalog.TargetEntityType;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Formattable;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

enum IndexToCypherRenderer implements Renderer<Index>
{
    INSTANCE;

    private static final Set<Neo4jVersion> RANGE_35_TO_42;
    private static final String ESCAPED_UNICODE_QUOTE = "\\u0027";
    private static final Pattern UNESCAPED_QUOTE;
    private static final UnaryOperator<String> TO_LITERAL;

    @Override
    public void render(Index index, RenderConfig config, OutputStream target) throws IOException {
        boolean isRelationshipPropertyIndex;
        Neo4jVersion version = config.getVersion();
        boolean bl = isRelationshipPropertyIndex = index.getType() == Index.Type.PROPERTY && index.getTargetEntityType() == TargetEntityType.RELATIONSHIP;
        if (!version.hasTextIndexes() && index.getType() == Index.Type.TEXT) {
            throw new IllegalArgumentException(String.format("The given index cannot be rendered on Neo4j %s", new Object[]{version}));
        }
        if (isRelationshipPropertyIndex && RANGE_35_TO_42.contains((Object)version)) {
            throw new IllegalArgumentException(String.format("The given relationship index cannot be rendered on Neo4j %s.", new Object[]{version}));
        }
        if (config.isIdempotent() && (!version.hasIdempotentOperations() || RANGE_35_TO_42.contains((Object)version) && index.getType() == Index.Type.FULLTEXT)) {
            throw new IllegalArgumentException(String.format("The given index cannot be rendered in an idempotent fashion on Neo4j %s.", new Object[]{version}));
        }
        if (!index.hasName() && config.isIdempotent() && config.getOperator() == Operator.DROP) {
            throw new IllegalArgumentException("The index can only be rendered in the given context when having a name.");
        }
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(target, StandardCharsets.UTF_8));
        switch ((Index.Type)index.getType()) {
            case POINT: 
            case PROPERTY: 
            case TEXT: 
            case VECTOR: {
                w.write(this.renderNodePropertiesIndex(index, config));
                break;
            }
            case FULLTEXT: {
                w.write(this.renderFulltextIndex(index, config));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type of constraint: " + String.valueOf(index.getType()));
            }
        }
        CypherRenderingUtils.renderOptions(index, config, w);
        ((Writer)w).flush();
    }

    private String renderFulltextIndex(Index index, RenderConfig config) {
        Operator operator = config.getOperator();
        Neo4jVersion version = config.getVersion();
        String indexName = index.getName().getValue();
        String identifier = IndexToCypherRenderer.getAndEscapeIdentifier(version, index);
        if (operator == Operator.CREATE) {
            return this.renderCreateFulltext(index, config, version, indexName, identifier);
        }
        return IndexToCypherRenderer.renderDropFulltext(index, config, version);
    }

    private String renderCreateFulltext(Index index, RenderConfig config, Neo4jVersion version, String indexName, String identifier) {
        String safeName = RANGE_35_TO_42.contains((Object)version) ? (String)TO_LITERAL.apply(indexName) : config.getVersion().sanitizeSchemaName(indexName);
        if (index.getTargetEntityType() == TargetEntityType.NODE) {
            String properties = this.renderFulltextProperties("n", index, config);
            if (RANGE_35_TO_42.contains((Object)version)) {
                return String.format("CALL db.index.fulltext.createNodeIndex(%s,[%s],[%s])", safeName, identifier, properties);
            }
            return String.format("CREATE FULLTEXT INDEX %s %sFOR (n:%s) ON EACH [%s]", safeName, config.ifNotExistsOrEmpty(), identifier, properties);
        }
        String properties = this.renderFulltextProperties("r", index, config);
        if (RANGE_35_TO_42.contains((Object)version)) {
            return String.format("CALL db.index.fulltext.createRelationshipIndex(%s,[%s],[%s])", safeName, identifier, properties);
        }
        return String.format("CREATE FULLTEXT INDEX %s %sFOR ()-[r:%s]-() ON EACH [%s]", safeName, config.ifNotExistsOrEmpty(), identifier, properties);
    }

    private static String renderDropFulltext(Index index, RenderConfig config, Neo4jVersion version) {
        if (RANGE_35_TO_42.contains((Object)version)) {
            return String.format("CALL db.index.fulltext.drop(%s)", TO_LITERAL.apply(index.getName().getValue()));
        }
        return String.format("DROP %#s%s", new FormattableCatalogItem(index, config.getVersion()), config.ifNotExistsOrEmpty());
    }

    private String renderNodePropertiesIndex(Index index, RenderConfig config) {
        Formattable item = this.formattablePropertyIndexItem(index, config);
        String identifier = IndexToCypherRenderer.getAndEscapeIdentifier(config.getVersion(), index, true);
        boolean isNodeIndex = index.getTargetEntityType() == TargetEntityType.NODE;
        String properties = isNodeIndex ? this.renderProperties("n", index, config) : this.renderProperties("r", index, config);
        Operator operator = config.getOperator();
        String type = IndexToCypherRenderer.determineType(index, config);
        Neo4jVersion version = config.getVersion();
        if (version == Neo4jVersion.V3_5) {
            return String.format("%s %#s ON :%s(%s)", new Object[]{operator, item, identifier, properties});
        }
        if (operator == Operator.DROP) {
            if (!index.hasName() || config.isIgnoreName()) {
                if (index.getProperties().size() == 1) {
                    return String.format("%s %#s ON :%s(%s)", new Object[]{operator, item, identifier, properties});
                }
                throw new IllegalStateException(String.format("Dropping an unnamed index is not supported on Neo4j %s.", new Object[]{version}));
            }
            return String.format("%s %#s%s", new Object[]{operator, item, config.ifNotExistsOrEmpty()});
        }
        if (isNodeIndex) {
            return String.format("%s%s%#s %sFOR (n:%s) ON (%s)%s", new Object[]{operator, type, item, config.ifNotExistsOrEmpty(), identifier, properties, index.getOptionalOptions().filter(ignored -> index.getType() == Index.Type.VECTOR).map(o -> " OPTIONS " + o).orElse("")});
        }
        return String.format("%s%s%#s %sFOR ()-[r:%s]-() ON (%s)", new Object[]{operator, type, item, config.ifNotExistsOrEmpty(), identifier, properties});
    }

    private static String determineType(Index index, RenderConfig config) {
        if (index.getType() == Index.Type.PROPERTY && !config.useExplicitPropertyIndexType()) {
            return " ";
        }
        if (index.isBtreePropertyIndex()) {
            return " BTREE ";
        }
        if (index.isRangePropertyIndex()) {
            return " RANGE ";
        }
        return " " + ((Index.Type)index.getType()).name() + " ";
    }

    private static String getAndEscapeIdentifier(Neo4jVersion version, Index index) {
        return IndexToCypherRenderer.getAndEscapeIdentifier(version, index, false);
    }

    private static String getAndEscapeIdentifier(Neo4jVersion version, Index index, boolean forceBackTicks) {
        if (RANGE_35_TO_42.contains((Object)version) && !forceBackTicks) {
            return index.getDeconstructedIdentifiers().stream().map(TO_LITERAL).collect(Collectors.joining(", "));
        }
        return index.getDeconstructedIdentifiers().stream().map(version::sanitizeSchemaName).collect(Collectors.joining("|"));
    }

    private String renderProperties(String prefix, Index item, RenderConfig config) {
        Neo4jVersion version;
        block3: {
            block2: {
                version = config.getVersion();
                if (version == Neo4jVersion.V3_5) break block2;
                if (config.getOperator() != Operator.DROP) break block3;
            }
            return item.getProperties().stream().map(version::sanitizeSchemaName).collect(Collectors.joining(", "));
        }
        return item.getProperties().stream().map(version::sanitizeSchemaName).map(v -> prefix + "." + v).collect(Collectors.joining(", "));
    }

    private String renderFulltextProperties(String prefix, Index item, RenderConfig config) {
        if (RANGE_35_TO_42.contains((Object)config.getVersion())) {
            return item.getProperties().stream().map(TO_LITERAL).collect(Collectors.joining(", "));
        }
        return item.getProperties().stream().map(v -> prefix + ".`" + v + "`").collect(Collectors.joining(", "));
    }

    Formattable formattablePropertyIndexItem(Index item, RenderConfig config) {
        return config.isIgnoreName() || config.getVersion() == Neo4jVersion.V3_5 ? new AnonymousCatalogItem(item) : new FormattableCatalogItem(item, config.getVersion());
    }

    static {
        RANGE_35_TO_42 = EnumSet.of(Neo4jVersion.V3_5, Neo4jVersion.V4_0, Neo4jVersion.V4_1, Neo4jVersion.V4_2);
        UNESCAPED_QUOTE = Pattern.compile("(?<!\\\\)'");
        TO_LITERAL = v -> {
            String result = UNESCAPED_QUOTE.matcher(v.replace(ESCAPED_UNICODE_QUOTE, "'")).replaceAll("\\\\'");
            return "'" + result + "'";
        };
    }
}

