/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.catalog;

import ac.simons.neo4j.migrations.core.Neo4jEdition;
import ac.simons.neo4j.migrations.core.Neo4jVersion;
import ac.simons.neo4j.migrations.core.catalog.Operator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class RenderConfig {
    private final Neo4jVersion version;
    private final Neo4jEdition edition;
    private final Operator operator;
    private final boolean idempotent;
    private final boolean ignoreName;
    private final List<AdditionalRenderingOptions> additionalOptions;
    private final boolean includingOptions;
    private final boolean useExplicitPropertyIndexType;

    static RenderConfig defaultConfig() {
        return new RenderConfig(Neo4jVersion.UNDEFINED, Neo4jEdition.UNDEFINED, null, true);
    }

    public static IfNotExistsConfigBuilder create() {
        return new DefaultBuilder(Operator.CREATE);
    }

    public static IfExistsConfigBuilder drop() {
        return new DefaultBuilder(Operator.DROP);
    }

    RenderConfig(Neo4jVersion version, Neo4jEdition edition, Operator operator, boolean idempotent) {
        this(version, edition, operator, idempotent, false, null);
    }

    RenderConfig(Neo4jVersion version, Neo4jEdition edition, Operator operator, boolean idempotent, boolean ignoreName, List<AdditionalRenderingOptions> additionalOptions) {
        this.version = version;
        this.edition = edition;
        this.operator = operator;
        this.idempotent = idempotent;
        this.ignoreName = ignoreName;
        this.additionalOptions = additionalOptions == null ? Collections.emptyList() : additionalOptions;
        List<CypherRenderingOptions> cypherRenderingOptions = this.additionalOptions.stream().filter(CypherRenderingOptions.class::isInstance).map(CypherRenderingOptions.class::cast).toList();
        this.includingOptions = cypherRenderingOptions.stream().map(CypherRenderingOptions::includingOptions).reduce(!cypherRenderingOptions.isEmpty(), (v1, v2) -> v1 != false && v2 != false);
        this.useExplicitPropertyIndexType = cypherRenderingOptions.stream().map(CypherRenderingOptions::useExplicitPropertyIndexType).reduce(!cypherRenderingOptions.isEmpty(), (v1, v2) -> v1 != false && v2 != false);
    }

    Neo4jVersion getVersion() {
        return this.version;
    }

    Neo4jEdition getEdition() {
        return this.edition;
    }

    Operator getOperator() {
        return this.operator;
    }

    boolean isIdempotent() {
        return this.idempotent;
    }

    boolean isVersionPriorTo44() {
        return this.getVersion().isPriorTo44();
    }

    boolean isIgnoreName() {
        return this.ignoreName;
    }

    List<AdditionalRenderingOptions> getAdditionalOptions() {
        return Collections.unmodifiableList(this.additionalOptions);
    }

    boolean includeOptions() {
        return this.includingOptions;
    }

    boolean useExplicitPropertyIndexType() {
        return this.useExplicitPropertyIndexType;
    }

    public RenderConfig ignoreName() {
        return new RenderConfig(this.version, this.edition, this.operator, this.idempotent, true, this.additionalOptions);
    }

    public RenderConfig withAdditionalOptions(List<? extends AdditionalRenderingOptions> newOptions) {
        if (Objects.equals(this.additionalOptions, newOptions)) {
            return this;
        }
        return new RenderConfig(this.version, this.edition, this.operator, this.idempotent, this.ignoreName, (List<AdditionalRenderingOptions>)(newOptions == null ? null : new ArrayList<AdditionalRenderingOptions>(newOptions)));
    }

    String ifNotExistsOrEmpty() {
        if (this.getOperator() == Operator.CREATE) {
            return this.isIdempotent() ? "IF NOT EXISTS " : "";
        }
        if (this.getOperator() == Operator.DROP) {
            return this.isIdempotent() ? " IF EXISTS" : "";
        }
        throw new IllegalStateException();
    }

    private static class DefaultBuilder
    implements IfNotExistsConfigBuilder,
    IfExistsConfigBuilder {
        private final Operator operator;
        private boolean idempotent;

        private DefaultBuilder(Operator operator) {
            this.operator = operator;
        }

        @Override
        public RenderConfig forVersionAndEdition(Neo4jVersion version, Neo4jEdition edition) {
            return new RenderConfig(version, edition, this.operator, this.idempotent);
        }

        @Override
        public Builder idempotent(boolean idempotent) {
            this.idempotent = idempotent;
            return this;
        }
    }

    public static interface CypherRenderingOptions
    extends AdditionalRenderingOptions {
        default public boolean includingOptions() {
            return false;
        }

        default public boolean useExplicitPropertyIndexType() {
            return false;
        }
    }

    public static interface Builder {
        default public RenderConfig forVersionAndEdition(String version, String edition) {
            return this.forVersionAndEdition(Neo4jVersion.of(version), Neo4jEdition.of(edition));
        }

        public RenderConfig forVersionAndEdition(Neo4jVersion var1, Neo4jEdition var2);

        public Builder idempotent(boolean var1);
    }

    public static interface IfExistsConfigBuilder
    extends Builder {
        default public Builder ifExists() {
            return this.idempotent(true);
        }
    }

    public static interface IfNotExistsConfigBuilder
    extends Builder {
        default public Builder ifNotExists() {
            return this.idempotent(true);
        }
    }

    public static interface XMLRenderingOptions
    extends AdditionalRenderingOptions {
        default public boolean withApply() {
            return false;
        }

        default public boolean withReset() {
            return false;
        }

        default public Optional<String> optionalHeader() {
            return Optional.empty();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface AdditionalRenderingOptions {
    }
}

