/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.refactorings;

import ac.simons.neo4j.migrations.core.refactorings.AbstractCustomizableRefactoring;
import ac.simons.neo4j.migrations.core.refactorings.AddSurrogateKey;
import ac.simons.neo4j.migrations.core.refactorings.Counters;
import ac.simons.neo4j.migrations.core.refactorings.DefaultCounters;
import ac.simons.neo4j.migrations.core.refactorings.FormatStringGenerator;
import ac.simons.neo4j.migrations.core.refactorings.QueryRunner;
import ac.simons.neo4j.migrations.core.refactorings.RefactoringContext;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.driver.Query;

final class DefaultAddSurrogateKey
extends AbstractCustomizableRefactoring
implements AddSurrogateKey {
    static final Pattern OPENING_CLOSING_BRACES = Pattern.compile("\\(?.+\\)");
    private final Target target;
    private final Set<String> identifiers;
    private final String property;
    private final String generator;
    private final QueryRunner.FeatureSet featureSet;

    DefaultAddSurrogateKey(Target target, Collection<String> identifiers, String property, String generator) {
        this(target, identifiers, property, generator, null, null);
    }

    DefaultAddSurrogateKey(Target target, String customQuery, String property, String generator) {
        this(target, null, property, generator, customQuery, null);
    }

    private DefaultAddSurrogateKey(Target target, Collection<String> identifiers, String property, String generator, String customQuery, Integer batchSize) {
        super(customQuery, batchSize);
        this.target = target;
        this.identifiers = identifiers == null ? Collections.emptySet() : (Set)identifiers.stream().map(String::trim).collect(Collectors.toCollection(LinkedHashSet::new));
        this.property = property;
        this.generator = generator;
        this.featureSet = this.batchSize != null ? QueryRunner.defaultFeatureSet().withRequiredVersion("4.4").withBatchingSupport(true) : (this.customQuery != null ? QueryRunner.defaultFeatureSet().withRequiredVersion("4.1") : QueryRunner.defaultFeatureSet().withRequiredVersion("3.5"));
    }

    @Override
    public AddSurrogateKey withProperty(String name) {
        if (name == null || name.isBlank()) {
            throw new IllegalArgumentException("Property name must not be null or blank");
        }
        return new DefaultAddSurrogateKey(this.target, this.identifiers, name, this.generator, this.customQuery, this.batchSize);
    }

    @Override
    public AddSurrogateKey withGeneratorFunction(String name) {
        if (name == null || name.isBlank()) {
            throw new IllegalArgumentException("Generator function must not be null or blank");
        }
        return new DefaultAddSurrogateKey(this.target, this.identifiers, this.property, name, this.customQuery, this.batchSize);
    }

    @Override
    public AddSurrogateKey inBatchesOf(Integer newBatchSize) {
        return this.inBatchesOf0(newBatchSize, AddSurrogateKey.class, v -> new DefaultAddSurrogateKey(this.target, (Collection<String>)this.identifiers, this.property, this.generator, this.customQuery, (Integer)v));
    }

    @Override
    public AddSurrogateKey withCustomQuery(String newCustomQuery) {
        return this.withCustomQuery0(newCustomQuery, AddSurrogateKey.class, v -> new DefaultAddSurrogateKey(this.target, (Collection<String>)(v != null ? null : this.identifiers), this.property, this.generator, (String)v, this.batchSize));
    }

    @Override
    public Counters apply(RefactoringContext context) {
        try (QueryRunner queryRunner = context.getQueryRunner(this.featureSet);){
            DefaultCounters defaultCounters = new DefaultCounters(queryRunner.run(this.generateQuery(context::sanitizeSchemaName, context::findSingleResultIdentifier)).consume().counters());
            return defaultCounters;
        }
    }

    static boolean isReadyMadeFunctionCall(String value) {
        return OPENING_CLOSING_BRACES.matcher(value.trim()).find();
    }

    Query generateQuery(UnaryOperator<String> sanitizer, Function<String, Optional<String>> elementExtractor) {
        String entityName = this.customQuery == null ? "" : elementExtractor.apply(this.customQuery).orElseThrow(IllegalArgumentException::new);
        String varName = switch (this.target.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> "n";
            case 0 -> "r";
        };
        String sanitizedIdentifiers = this.identifiers.stream().map(sanitizer).collect(Collectors.joining(":"));
        String sanitizedProperty = (String)sanitizer.apply(this.property);
        Object generatorCall = DefaultAddSurrogateKey.isReadyMadeFunctionCall(this.generator) ? String.format(this.generator, varName) : this.generator + "()";
        return new Query(String.format(this.target.generateFormatString(this.customQuery, this.batchSize), sanitizedIdentifiers, sanitizedProperty, generatorCall, this.batchSize, this.customQuery, entityName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultAddSurrogateKey that = (DefaultAddSurrogateKey)o;
        return this.target == that.target && this.identifiers.equals(that.identifiers) && this.property.equals(that.property) && this.generator.equals(that.generator);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.identifiers, this.property, this.generator);
    }

    Target getTarget() {
        return this.target;
    }

    Set<String> getIdentifiers() {
        return Collections.unmodifiableSet(this.identifiers);
    }

    String getProperty() {
        return this.property;
    }

    String getGenerator() {
        return this.generator;
    }

    static enum Target implements FormatStringGenerator
    {
        RELATIONSHIP("MATCH ()-[r:%1$s]->() WHERE r.%2$s IS NULL", "CALL { %5$s } WITH %6$s AS r", "SET r.%2$s = %3$s", "CALL { WITH r SET r.%2$s = %3$s } IN TRANSACTIONS OF %4$d ROWS"),
        NODE("MATCH (n:%1$s) WHERE n.%2$s IS NULL", "CALL { %5$s } WITH %6$s AS n", "SET n.%2$s = %3$s", "CALL { WITH n SET n.%2$s = %3$s } IN TRANSACTIONS OF %4$d ROWS");

        private final FormatStringGenerator.Fragments fragments;

        private Target(String sourceFragment, String sourceFragmentWithCustomQuery, String actionFragment, String actionFragmentWithBatchSize) {
            this.fragments = new FormatStringGenerator.Fragments(sourceFragment, sourceFragmentWithCustomQuery, actionFragment, actionFragmentWithBatchSize);
        }

        @Override
        public FormatStringGenerator.Fragments getFragments() {
            return this.fragments;
        }
    }
}

