/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.CypherResource;
import ac.simons.neo4j.migrations.core.DefaultCypherResource;
import ac.simons.neo4j.migrations.core.Migration;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import ac.simons.neo4j.migrations.core.MigrationsException;
import java.util.Optional;
import java.util.function.UnaryOperator;

public abstract class AbstractCypherBasedMigration
implements Migration {
    protected final CypherResource cypherResource;
    protected final MigrationVersion version;

    protected AbstractCypherBasedMigration(CypherResource cypherResource) {
        this.cypherResource = cypherResource;
        this.version = MigrationVersion.parse(this.cypherResource.getIdentifier());
    }

    @Override
    public final MigrationVersion getVersion() {
        return this.version;
    }

    @Override
    public Optional<String> getOptionalDescription() {
        return this.version.getOptionalDescription();
    }

    @Override
    public String getSource() {
        return this.cypherResource.getIdentifier();
    }

    @Override
    public final Optional<String> getChecksum() {
        return Optional.of(this.cypherResource.getChecksum());
    }

    @Override
    public final void apply(MigrationContext context) throws MigrationsException {
        DefaultCypherResource.executeIn(this.cypherResource, context, UnaryOperator.identity());
    }

    @Override
    public final boolean isRepeatable() {
        return this.getVersion().isRepeatable();
    }
}

