/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.DatabaseOperationResult;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractRepairmentResult
implements DatabaseOperationResult {
    private final String affectedDatabase;
    private final long nodesDeleted;
    private final long nodesCreated;
    private final long relationshipsDeleted;
    private final long relationshipsCreated;
    private final long propertiesSet;

    AbstractRepairmentResult(String affectedDatabase, long nodesDeleted, long nodesCreated, long relationshipsDeleted, long relationshipsCreated, long propertiesSet) {
        this.affectedDatabase = affectedDatabase;
        this.nodesDeleted = nodesDeleted;
        this.nodesCreated = nodesCreated;
        this.relationshipsDeleted = relationshipsDeleted;
        this.relationshipsCreated = relationshipsCreated;
        this.propertiesSet = propertiesSet;
    }

    @Override
    public Optional<String> getAffectedDatabase() {
        return Optional.ofNullable(this.affectedDatabase);
    }

    public long getNodesDeleted() {
        return this.nodesDeleted;
    }

    public long getNodesCreated() {
        return this.nodesCreated;
    }

    public long getRelationshipsDeleted() {
        return this.relationshipsDeleted;
    }

    public long getRelationshipsCreated() {
        return this.relationshipsCreated;
    }

    public long getPropertiesSet() {
        return this.propertiesSet;
    }

    static String toString(MigrationVersion version) {
        return version.getValue() + version.getOptionalDescription().map(d -> String.format(" (\"%s\")", d)).orElse("");
    }
}

