/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.CatalogBasedRefactorings;
import ac.simons.neo4j.migrations.core.DatabaseCatalog;
import ac.simons.neo4j.migrations.core.DefaultRefactoringContext;
import ac.simons.neo4j.migrations.core.Defaults;
import ac.simons.neo4j.migrations.core.Migration;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import ac.simons.neo4j.migrations.core.MigrationWithPreconditions;
import ac.simons.neo4j.migrations.core.Migrations;
import ac.simons.neo4j.migrations.core.MigrationsException;
import ac.simons.neo4j.migrations.core.Neo4jCodes;
import ac.simons.neo4j.migrations.core.Neo4jEdition;
import ac.simons.neo4j.migrations.core.Neo4jVersion;
import ac.simons.neo4j.migrations.core.Precondition;
import ac.simons.neo4j.migrations.core.VersionedCatalog;
import ac.simons.neo4j.migrations.core.catalog.Catalog;
import ac.simons.neo4j.migrations.core.catalog.CatalogDiff;
import ac.simons.neo4j.migrations.core.catalog.CatalogItem;
import ac.simons.neo4j.migrations.core.catalog.Constraint;
import ac.simons.neo4j.migrations.core.catalog.Index;
import ac.simons.neo4j.migrations.core.catalog.Name;
import ac.simons.neo4j.migrations.core.catalog.Operator;
import ac.simons.neo4j.migrations.core.catalog.RenderConfig;
import ac.simons.neo4j.migrations.core.catalog.Renderer;
import ac.simons.neo4j.migrations.core.internal.NodeSetDataImpl;
import ac.simons.neo4j.migrations.core.internal.NoopDOMCryptoContext;
import ac.simons.neo4j.migrations.core.internal.ThrowingErrorHandler;
import ac.simons.neo4j.migrations.core.internal.XMLSchemaConstants;
import ac.simons.neo4j.migrations.core.refactorings.Counters;
import ac.simons.neo4j.migrations.core.refactorings.Refactoring;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.neo4j.driver.QueryRunner;
import org.neo4j.driver.Session;
import org.neo4j.driver.SimpleQueryRunner;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.summary.SummaryCounters;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class CatalogBasedMigration
implements MigrationWithPreconditions {
    private static final Logger LOGGER = Logger.getLogger(CatalogBasedMigration.class.getName());
    private static final Schema MIGRATION_SCHEMA;
    private static final ThreadLocal<DocumentBuilderFactory> DOCUMENT_BUILDER_FACTORY;
    private final String source;
    private final MigrationVersion version;
    private final String checksum;
    private final Catalog catalog;
    private final List<Operation> operations;
    private final List<Precondition> preconditions;
    private final boolean resetCatalog;
    private List<String> alternativeChecksums = Collections.emptyList();

    private static String computeChecksum(Document document) {
        NodeList allElements = document.getElementsByTagName("*");
        Element newCatalog = document.createElement("catalog");
        Node oldCatalog = null;
        Node constraints = null;
        Node indexes = null;
        ArrayList<Node> elements = new ArrayList<Node>();
        for (int i = 0; i < allElements.getLength(); ++i) {
            Node currentItem = allElements.item(i);
            if (currentItem.getLocalName().equals("catalog")) {
                oldCatalog = currentItem;
                continue;
            }
            if (currentItem.getLocalName().equals("indexes")) {
                indexes = currentItem;
            } else if (currentItem.getLocalName().equals("constraints")) {
                constraints = currentItem;
            }
            elements.add(currentItem);
            NodeList childNodes = currentItem.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                CharacterData textNode;
                Node childItem = childNodes.item(j);
                if (!(childItem instanceof CharacterData) || (textNode = (CharacterData)childItem).getTextContent().trim().isEmpty()) continue;
                String content = Arrays.stream(textNode.getTextContent().split("\r?\n")).map(String::trim).collect(Collectors.joining("\n"));
                textNode.setData(content);
                elements.add(textNode);
            }
        }
        if (oldCatalog != null) {
            CatalogBasedMigration.updateCatalog(oldCatalog, newCatalog);
        }
        if (constraints != null) {
            newCatalog.appendChild(constraints);
        }
        if (indexes != null) {
            newCatalog.appendChild(indexes);
        }
        elements.add(newCatalog);
        return CatalogBasedMigration.canonicalizeAndChecksumElements(document, elements);
    }

    private static void updateCatalog(Node oldCatalog, Node newCatalog) {
        oldCatalog.getParentNode().replaceChild(newCatalog, oldCatalog);
        NamedNodeMap attributes = oldCatalog.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            attributes.removeNamedItem(attribute.getNodeName());
            newCatalog.getAttributes().setNamedItem(attribute);
        }
    }

    private static String canonicalizeAndChecksumElements(Document document, List<Node> elements) {
        String string;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            NoopDOMCryptoContext cryptoContext = new NoopDOMCryptoContext();
            TransformService transformService = TransformService.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "DOM");
            transformService.init(new DOMStructure(document.createElement("holder")), cryptoContext);
            transformService.transform(NodeSetDataImpl.of(elements), cryptoContext, os);
            os.flush();
            CRC32 crc32 = new CRC32();
            byte[] bytes = os.toByteArray();
            crc32.update(bytes, 0, bytes.length);
            string = Long.toString(crc32.getValue());
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | TransformException e) {
                throw new MigrationsException("Could not canonicalize an xml document", e);
            }
        }
        os.close();
        return string;
    }

    static Migration from(URL url) {
        String path = URLDecoder.decode(url.getPath(), Defaults.CYPHER_SCRIPT_ENCODING);
        int lastIndexOf = path.lastIndexOf("/");
        String fileName = lastIndexOf < 0 ? path : path.substring(lastIndexOf + 1);
        MigrationVersion version = MigrationVersion.parse(fileName);
        Document document = CatalogBasedMigration.parseDocument(url);
        return new CatalogBasedMigration(fileName, version, CatalogBasedMigration.computeChecksum(document), Catalog.of(document), CatalogBasedMigration.parseOperations(document, version), CatalogBasedMigration.getPreconditions(document), CatalogBasedMigration.isResetCatalog(document));
    }

    static Document parseDocument(URL url) {
        Document document;
        block9: {
            InputStream source = url.openStream();
            try {
                DocumentBuilder documentBuilder = DOCUMENT_BUILDER_FACTORY.get().newDocumentBuilder();
                documentBuilder.setErrorHandler(new ThrowingErrorHandler());
                Document document2 = documentBuilder.parse(source);
                document2.normalizeDocument();
                document = document2;
                if (source == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SAXParseException e) {
                    throw new MigrationsException("Could not parse migration: " + e.getMessage());
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    throw new MigrationsException("Could not parse the given document", e);
                }
            }
            source.close();
        }
        return document;
    }

    static boolean isResetCatalog(Document document) {
        NodeList catalog = document.getElementsByTagName("catalog");
        return catalog.getLength() == 1 && Boolean.parseBoolean(((Element)catalog.item(0)).getAttribute("reset"));
    }

    static List<Precondition> getPreconditions(Node parentNode) {
        ArrayList<Precondition> result = new ArrayList<Precondition>();
        NodeList childNodes = parentNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 7) {
                Precondition.parse(String.format("// %s %s", node.getNodeName(), node.getTextContent().trim())).ifPresent(result::add);
                continue;
            }
            if (node.getNodeType() != 1) continue;
            result.addAll(CatalogBasedMigration.getPreconditions(node));
        }
        return result;
    }

    static List<Operation> parseOperations(Document document, MigrationVersion version) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        NodeList migration = document.getElementsByTagName("migration");
        if (migration.getLength() != 1) {
            throw new MigrationsException("Invalid document: No <migration /> element.");
        }
        NodeList childNodes = migration.item(0).getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            String nodeName = node.getNodeName();
            if (!(node instanceof Element) || !XMLSchemaConstants.SUPPORTED_OPERATIONS.contains(nodeName)) {
                LOGGER.fine(() -> String.format("Skipping node: %s", nodeName));
                continue;
            }
            if ("refactor".equals(nodeName)) {
                result.add(Operation.refactorWith(CatalogBasedRefactorings.fromNode(node)));
                continue;
            }
            OperationType type = OperationType.valueOf(nodeName.toUpperCase(Locale.ROOT));
            result.add(type.build((Element)node, version));
        }
        Comparator catalogItemComparator = CatalogBasedMigration::compareCatalogItems;
        return result.stream().sorted((operation1, operation2) -> {
            if (operation1 instanceof ItemSpecificOperation) {
                ItemSpecificOperation isop1 = (ItemSpecificOperation)operation1;
                if (operation2 instanceof ItemSpecificOperation) {
                    ItemSpecificOperation isop2 = (ItemSpecificOperation)operation2;
                    if (isop1.getLocalItem().isPresent() && isop2.getLocalItem().isPresent()) {
                        CatalogItem<?> item1 = isop1.getLocalItem().get();
                        CatalogItem<?> item2 = isop2.getLocalItem().get();
                        return catalogItemComparator.compare(item1, item2);
                    }
                }
            }
            return 0;
        }).toList();
    }

    private CatalogBasedMigration(String source, MigrationVersion version, String checksum, Catalog catalog, List<Operation> operations, List<Precondition> preconditions, boolean resetCatalog) {
        this.source = source;
        this.version = version;
        this.checksum = checksum;
        this.catalog = catalog;
        this.operations = operations;
        this.preconditions = preconditions;
        this.resetCatalog = resetCatalog;
    }

    private static int compareCatalogItems(CatalogItem<?> o1, CatalogItem<?> o2) {
        if (o1 instanceof Constraint && o2 instanceof Index) {
            return -1;
        }
        if (o2 instanceof Constraint && o1 instanceof Index) {
            return 1;
        }
        return 0;
    }

    @Override
    public Optional<String> getChecksum() {
        return Optional.of(this.checksum);
    }

    @Override
    public List<String> getAlternativeChecksums() {
        return Collections.unmodifiableList(this.alternativeChecksums);
    }

    @Override
    public void setAlternativeChecksums(List<String> alternativeChecksums) {
        Objects.requireNonNull(alternativeChecksums);
        this.alternativeChecksums = new ArrayList<String>(alternativeChecksums);
    }

    @Override
    public MigrationVersion getVersion() {
        return this.version;
    }

    @Override
    public Optional<String> getOptionalDescription() {
        return this.version.getOptionalDescription();
    }

    @Override
    public String getSource() {
        return this.source;
    }

    Catalog getCatalog() {
        return this.catalog;
    }

    boolean isResetCatalog() {
        return this.resetCatalog;
    }

    @Override
    public void apply(MigrationContext context) {
        Neo4jVersion neo4jVersion = Neo4jVersion.of(context.getConnectionDetails().getServerVersion());
        Neo4jEdition neo4jEdition = Neo4jEdition.of(context.getConnectionDetails().getServerEdition());
        Catalog globalCatalog = context.getCatalog();
        if (!(globalCatalog instanceof VersionedCatalog)) {
            throw new MigrationsException("Cannot use catalog based migrations without a versioned catalog.");
        }
        try {
            OperationContext operationContext = new OperationContext(neo4jVersion, neo4jEdition, (VersionedCatalog)globalCatalog, context::getSession);
            Counters counters = ((Stream)this.operations.stream().sequential()).map(op -> op.execute(operationContext)).reduce(Counters.empty(), Counters::add);
            LOGGER.fine(() -> String.format("Removed %d constraints and %d indexes, added %d constraints and %d indexes in total.", counters.constraintsRemoved(), counters.indexesRemoved(), counters.constraintsAdded(), counters.indexesAdded()));
            LOGGER.fine(() -> String.format("Removed %d labels and %d types, added %d labels and %d types and modified %d properties in total.", counters.labelsRemoved(), counters.typesRemoved(), counters.labelsAdded(), counters.typesAdded(), counters.propertiesSet()));
        }
        catch (VerificationFailedException e) {
            throw new MigrationsException("Could not apply migration " + Migrations.toString(this) + " verification failed: " + e.getMessage());
        }
    }

    @Override
    public boolean isRepeatable() {
        return this.version.isRepeatable();
    }

    @Override
    public List<Precondition> getPreconditions() {
        return Collections.unmodifiableList(this.preconditions);
    }

    static Counters schemaCounters(SummaryCounters summaryCounters) {
        Map<String, Integer> schema = Map.of("indexesAdded", summaryCounters.indexesAdded(), "indexesRemoved", summaryCounters.indexesRemoved(), "constraintsAdded", summaryCounters.constraintsAdded(), "constraintsRemoved", summaryCounters.constraintsRemoved());
        return Counters.of(schema);
    }

    static Counters schemaCounters(int indexesAdded, int indexesRemoved, int constraintsAdded, int constraintsRemoved) {
        Map<String, Integer> schema = Map.of("indexesAdded", indexesAdded, "indexesRemoved", indexesRemoved, "constraintsAdded", constraintsAdded, "constraintsRemoved", constraintsRemoved);
        return Counters.of(schema);
    }

    static {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            MIGRATION_SCHEMA = schemaFactory.newSchema(new StreamSource(CatalogBasedMigration.class.getResourceAsStream("/ac/simons/neo4j/migrations/core/migration.xsd")));
        }
        catch (SAXException e) {
            throw new MigrationsException("Could not load XML schema definition for schema based migrations.", e);
        }
        DOCUMENT_BUILDER_FACTORY = ThreadLocal.withInitial(() -> {
            DocumentBuilderFactory value = DocumentBuilderFactory.newInstance();
            value.setSchema(MIGRATION_SCHEMA);
            value.setExpandEntityReferences(false);
            value.setNamespaceAware(true);
            return value;
        });
    }

    static interface Operation {
        public static OperationBuilder<DropOperation> drop(Name name, boolean ifExits) {
            return new DefaultOperationBuilder(Operator.DROP).drop(name, ifExits);
        }

        public static OperationBuilder<CreateOperation> create(Name name, boolean ifNotExists) {
            return new DefaultOperationBuilder(Operator.CREATE).create(name, ifNotExists);
        }

        public static DropOperation drop(CatalogItem<?> item, boolean ifExits) {
            return new DefaultOperationBuilder(Operator.DROP).drop(item, ifExits);
        }

        public static CreateOperation create(CatalogItem<?> item, boolean ifNotExists) {
            return new DefaultOperationBuilder(Operator.CREATE).create(item, ifNotExists);
        }

        public static Operation refactorWith(Refactoring refactoring) {
            return new DefaultRefactorOperation(refactoring);
        }

        public static ApplyOperation apply(MigrationVersion definedAt) {
            return new DefaultApplyOperation(definedAt);
        }

        public static VerifyBuilder verify(boolean useCurrent) {
            return new DefaultOperationBuilder(null).verify(useCurrent);
        }

        public Counters execute(OperationContext var1);
    }

    private static enum OperationType {
        VERIFY,
        CREATE,
        DROP,
        APPLY;


        Operation build(Element operationElement, MigrationVersion targetVersion) {
            switch (this) {
                case VERIFY: {
                    return Operation.verify(Boolean.parseBoolean(operationElement.getAttribute("useCurrent"))).includeOptions(Boolean.parseBoolean(operationElement.getAttribute("includeOptions"))).allowEquivalent(Boolean.parseBoolean(operationElement.getAttribute("allowEquivalent"))).at(targetVersion);
                }
                case CREATE: 
                case DROP: {
                    Optional<Name> optionalName = this.getOptionalReference(operationElement);
                    boolean ifNotExists = Boolean.parseBoolean(operationElement.getAttribute("ifNotExists"));
                    boolean ifExists = Boolean.parseBoolean(operationElement.getAttribute("ifExists"));
                    return optionalName.map(name -> {
                        OperationBuilder<VersionSpecificOperation> builder = this == CREATE ? Operation.create((Name)optionalName.get(), ifNotExists) : Operation.drop((Name)optionalName.get(), ifExists);
                        return builder.with(targetVersion);
                    }).orElseGet(() -> this == CREATE ? Operation.create(this.getLocalItem(operationElement), ifNotExists) : Operation.drop(this.getLocalItem(operationElement), ifExists));
                }
                case APPLY: {
                    return Operation.apply(targetVersion);
                }
            }
            throw new IllegalArgumentException("Unsupported operation type: " + this);
        }

        private Optional<Name> getOptionalReference(Element operationElement) {
            if (operationElement.hasAttribute("ref") && operationElement.hasAttribute("item")) {
                throw new IllegalArgumentException("Cannot create an operation referring to an item with both ref and item attributes. Please pick one.");
            }
            if ((operationElement.hasAttribute("ref") || operationElement.hasAttribute("item")) && this.hasLocalItem(operationElement)) {
                throw new IllegalArgumentException("Cannot create an operation referring to an element and defining an item locally at the same time.");
            }
            if (operationElement.hasAttribute("ref")) {
                return Optional.of(Name.of(operationElement.getAttribute("ref")));
            }
            if (operationElement.hasAttribute("item")) {
                return Optional.of(Name.of(operationElement.getAttribute("item")));
            }
            return Optional.empty();
        }

        private CatalogItem<?> getLocalItem(Element operationElement) {
            if (operationElement.getElementsByTagName("constraint").getLength() == 1) {
                return Constraint.parse((Element)operationElement.getElementsByTagName("constraint").item(0));
            }
            if (operationElement.getElementsByTagName("index").getLength() == 1) {
                return Index.parse((Element)operationElement.getElementsByTagName("index").item(0));
            }
            throw new UnsupportedOperationException("Could not get a local catalog item.");
        }

        private boolean hasLocalItem(Element operationElement) {
            if (!operationElement.hasChildNodes()) {
                return false;
            }
            NodeList childNodes = operationElement.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                if (!(child instanceof Element)) continue;
                return true;
            }
            return false;
        }
    }

    record OperationContext(Neo4jVersion version, Neo4jEdition edition, VersionedCatalog catalog, Supplier<Session> sessionSupplier) {
    }

    static final class VerificationFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 6481650211840799118L;

        VerificationFailedException(String message) {
            super(message);
        }
    }

    static interface ItemSpecificOperation
    extends Operation {
        public Optional<Name> getReference();

        public Optional<CatalogItem<?>> getLocalItem();
    }

    record DefaultApplyOperation(MigrationVersion definedAt) implements ApplyOperation
    {
        @Override
        public Counters execute(OperationContext context) {
            try (Session queryRunner = context.sessionSupplier.get();){
                Catalog databaseCatalog = DatabaseCatalog.of(context.version, (SimpleQueryRunner)queryRunner, false);
                RenderConfig dropConfig = RenderConfig.drop().forVersionAndEdition(context.version, context.edition);
                AtomicInteger constraintsRemoved = new AtomicInteger(0);
                AtomicInteger indexesRemoved = new AtomicInteger(0);
                databaseCatalog.getItems().forEach(catalogItem -> {
                    Renderer<CatalogItem> renderer = Renderer.get(Renderer.Format.CYPHER, catalogItem);
                    SummaryCounters counters = queryRunner.run(renderer.render((CatalogItem)catalogItem, dropConfig)).consume().counters();
                    constraintsRemoved.addAndGet(counters.constraintsRemoved());
                    indexesRemoved.addAndGet(counters.indexesRemoved());
                });
                RenderConfig createConfig = RenderConfig.create().forVersionAndEdition(context.version, context.edition);
                AtomicInteger constraintsAdded = new AtomicInteger(0);
                AtomicInteger indexesAdded = new AtomicInteger(0);
                context.catalog.getCatalogAt(this.definedAt).getItems().forEach(item -> {
                    Renderer<CatalogItem> renderer = Renderer.get(Renderer.Format.CYPHER, item);
                    SummaryCounters counters = queryRunner.run(renderer.render((CatalogItem)item, createConfig)).consume().counters();
                    constraintsAdded.addAndGet(counters.constraintsAdded());
                    indexesAdded.addAndGet(counters.indexesAdded());
                });
                Counters counters = CatalogBasedMigration.schemaCounters(indexesAdded.get(), indexesRemoved.get(), constraintsAdded.get(), constraintsRemoved.get());
                return counters;
            }
        }
    }

    record DefaultVerifyOperation(boolean useCurrent, boolean includeOptions, boolean allowEquivalent, MigrationVersion definedAt) implements VerifyOperation
    {
        @Override
        public Counters execute(OperationContext context) {
            try (Session queryRunner = context.sessionSupplier.get();){
                Catalog databaseCatalog = DatabaseCatalog.of(context.version, (SimpleQueryRunner)queryRunner, this.includeOptions);
                VersionedCatalog currentCatalog = context.catalog;
                CatalogDiff diff = CatalogDiff.between(databaseCatalog, this.useCurrent ? currentCatalog.getCatalogAt(this.definedAt) : currentCatalog.getCatalogPriorTo(this.definedAt));
                if (diff.identical()) {
                    LOGGER.log(Level.FINE, "Database schema and catalog are identical.");
                } else if (diff.equivalent() && this.allowEquivalent) {
                    LOGGER.warning(() -> this.buildEquivalentWarningMessage(diff));
                } else {
                    throw new VerificationFailedException(diff.equivalent() ? "Database schema and the catalog are equivalent but the verification requires them to be identical." : "Catalogs are neither identical nor equivalent.");
                }
                Counters counters = Counters.empty();
                return counters;
            }
        }

        private String buildEquivalentWarningMessage(CatalogDiff diff) {
            StringBuilder message = new StringBuilder();
            Collection<CatalogItem<?>> itemsOnlyInRight = diff.getItemsOnlyInRight();
            message.append("Items in the database are not identical to items in the schema catalog. The following items have different names but an equivalent definition:");
            diff.getItemsOnlyInLeft().forEach(item -> itemsOnlyInRight.stream().filter(item::isEquivalentTo).findFirst().ifPresent(equivalentItem -> message.append(System.lineSeparator()).append("* Database item `").append(item.getName().getValue()).append("` matches catalog item `").append(equivalentItem.getName().getValue()).append("`")));
            return message.toString();
        }
    }

    static final class DefaultDropOperation
    extends AbstractItemBasedOperation
    implements DropOperation {
        DefaultDropOperation(MigrationVersion definedAt, Name reference, CatalogItem<?> item, boolean idempotent) {
            super(definedAt, reference, item, idempotent);
        }

        @Override
        public Counters execute(OperationContext context) {
            try (Session queryRunner = context.sessionSupplier.get();){
                CatalogItem<?> item = this.getRequiredItem(context.catalog);
                Renderer<CatalogItem<?>> renderer = Renderer.get(Renderer.Format.CYPHER, item);
                RenderConfig config = RenderConfig.drop().idempotent(this.idempotent).forVersionAndEdition(context.version, context.edition);
                if (this.idempotent && !context.version.hasIdempotentOperations()) {
                    config = config.ignoreName();
                    Counters counters = this.drop(context, item, (QueryRunner)queryRunner, renderer, config, true);
                    return counters;
                }
                Counters counters = CatalogBasedMigration.schemaCounters(queryRunner.run(renderer.render(item, config)).consume().counters());
                return counters;
            }
        }

        private Counters drop(OperationContext context, CatalogItem<?> item, QueryRunner queryRunner, Renderer<CatalogItem<?>> renderer, RenderConfig config, boolean fallbackToPrior) {
            try {
                return CatalogBasedMigration.schemaCounters(queryRunner.run(renderer.render(item, config)).consume().counters());
            }
            catch (Neo4jException e) {
                List items;
                if (!"Neo.DatabaseError.Schema.ConstraintDropFailed".equals(e.code())) {
                    throw e;
                }
                if (!(item instanceof Constraint) && !(item instanceof Index)) {
                    throw new IllegalStateException("Item type " + item.getClass() + " not supported");
                }
                List list = items = item instanceof Constraint ? queryRunner.run(context.version.getShowConstraints()).list(Constraint::parse) : queryRunner.run(context.version.getShowIndexes()).list(Index::parse);
                if (items.isEmpty()) {
                    return Counters.empty();
                }
                if (items.stream().anyMatch(existingIndex -> existingIndex.isEquivalentTo(item))) {
                    throw e;
                }
                if (!fallbackToPrior || this.getLocalItem().isPresent()) {
                    return Counters.empty();
                }
                return context.catalog.getItemPriorTo(this.reference, this.definedAt).filter(v -> items.stream().anyMatch(existingIndex -> existingIndex.isEquivalentTo((CatalogItem<?>)v))).map(olderItem -> this.drop(context, (CatalogItem<?>)olderItem, queryRunner, renderer, config, false)).orElseGet(Counters::empty);
            }
        }
    }

    static final class DefaultCreateOperation
    extends AbstractItemBasedOperation
    implements CreateOperation {
        DefaultCreateOperation(MigrationVersion definedAt, Name reference, CatalogItem<?> item, boolean idempotent) {
            super(definedAt, reference, item, idempotent);
        }

        @Override
        public Counters execute(OperationContext context) {
            try (Session queryRunner = context.sessionSupplier.get();){
                CatalogItem<?> item = this.getRequiredItem(context.catalog);
                Renderer<CatalogItem<?>> renderer = Renderer.get(Renderer.Format.CYPHER, item);
                RenderConfig config = RenderConfig.create().idempotent(this.idempotent).forVersionAndEdition(context.version, context.edition);
                if (this.idempotent && !context.version.hasIdempotentOperations()) {
                    config = config.ignoreName();
                    Counters counters = this.createIfNotExists(context, item, (QueryRunner)queryRunner, renderer, config);
                    return counters;
                }
                Counters counters = CatalogBasedMigration.schemaCounters(queryRunner.run(renderer.render(item, config)).consume().counters());
                return counters;
            }
        }

        private Counters createIfNotExists(OperationContext context, CatalogItem<?> item, QueryRunner queryRunner, Renderer<CatalogItem<?>> renderer, RenderConfig config) {
            try {
                return CatalogBasedMigration.schemaCounters(queryRunner.run(renderer.render(item, config)).consume().counters());
            }
            catch (Neo4jException e) {
                List items;
                if (!Neo4jCodes.CODES_FOR_EXISTING_CONSTRAINT.contains(e.code())) {
                    throw e;
                }
                List list = items = item instanceof Constraint ? queryRunner.run(context.version.getShowConstraints()).list(Constraint::parse) : queryRunner.run(context.version.getShowIndexes()).list(Index::parse);
                if (items.isEmpty() || items.stream().noneMatch(existingItem -> existingItem.isEquivalentTo(item))) {
                    throw e;
                }
                return Counters.empty();
            }
        }
    }

    private static abstract class AbstractItemBasedOperation
    implements VersionSpecificOperation,
    ItemSpecificOperation {
        protected final MigrationVersion definedAt;
        protected final Name reference;
        protected final CatalogItem<?> localItem;
        protected final boolean idempotent;

        AbstractItemBasedOperation(MigrationVersion definedAt, Name reference, CatalogItem<?> localItem, boolean idempotent) {
            if (definedAt == null && localItem == null) {
                throw new IllegalArgumentException("Without a version, a concrete, local item is required.");
            }
            if (reference != null && localItem != null) {
                throw new IllegalArgumentException("Either reference or item is required, not both.");
            }
            this.definedAt = definedAt;
            this.reference = reference;
            this.localItem = localItem;
            this.idempotent = idempotent;
        }

        CatalogItem<?> getRequiredItem(VersionedCatalog catalog) {
            if (this.localItem != null) {
                return this.localItem;
            }
            return catalog.getItem(this.reference, this.definedAt).orElseThrow(() -> new MigrationsException(String.format("An item named '%s' has not been defined as of version %s.", this.reference.getValue(), this.definedAt.getValue())));
        }

        @Override
        public MigrationVersion definedAt() {
            return this.definedAt;
        }

        @Override
        public Optional<Name> getReference() {
            return Optional.ofNullable(this.reference);
        }

        @Override
        public Optional<CatalogItem<?>> getLocalItem() {
            return Optional.ofNullable(this.localItem);
        }
    }

    private static class DefaultOperationBuilder<T extends Operation>
    implements OperationBuilder<T>,
    VerifyBuilder {
        private final Operator operator;
        private Name reference;
        private CatalogItem<?> item;
        private boolean idempotent;
        private boolean useCurrent;
        private boolean allowEquivalent = true;
        private boolean includingOptions = false;

        DefaultOperationBuilder(Operator operator) {
            this.operator = operator;
        }

        OperationBuilder<T> drop(Name reference, boolean ifExits) {
            this.reference = reference;
            this.idempotent = ifExits;
            return this;
        }

        OperationBuilder<T> create(Name reference, boolean ifNotExists) {
            this.reference = reference;
            this.idempotent = ifNotExists;
            return this;
        }

        DropOperation drop(CatalogItem<?> item, boolean ifExits) {
            this.item = item;
            this.idempotent = ifExits;
            return new DefaultDropOperation(null, this.reference, item, this.idempotent);
        }

        CreateOperation create(CatalogItem<?> item, boolean ifNotExists) {
            this.item = item;
            this.idempotent = ifNotExists;
            return new DefaultCreateOperation(null, this.reference, item, this.idempotent);
        }

        VerifyBuilder verify(boolean useCurrent) {
            this.useCurrent = useCurrent;
            return this;
        }

        @Override
        public VerifyBuilder includeOptions(boolean includeOptions) {
            this.includingOptions = includeOptions;
            return this;
        }

        @Override
        public TerminalVerifyBuilder allowEquivalent(boolean allowEquivalent) {
            this.allowEquivalent = allowEquivalent;
            return this;
        }

        @Override
        public VerifyOperation at(MigrationVersion version) {
            return new DefaultVerifyOperation(this.useCurrent, this.includingOptions, this.allowEquivalent, version);
        }

        @Override
        public T with(MigrationVersion version) {
            if (this.operator == Operator.DROP) {
                return (T)new DefaultDropOperation(version, this.reference, this.item, this.idempotent);
            }
            if (this.operator == Operator.CREATE) {
                return (T)new DefaultCreateOperation(version, this.reference, this.item, this.idempotent);
            }
            throw new UnsupportedOperationException();
        }
    }

    static interface VerifyBuilder
    extends TerminalVerifyBuilder {
        public VerifyBuilder includeOptions(boolean var1);

        public TerminalVerifyBuilder allowEquivalent(boolean var1);
    }

    static interface TerminalVerifyBuilder {
        public VerifyOperation at(MigrationVersion var1);
    }

    static interface OperationBuilder<T extends Operation> {
        public T with(MigrationVersion var1);
    }

    static interface VerifyOperation
    extends VersionSpecificOperation {
        public boolean useCurrent();

        public boolean allowEquivalent();

        public boolean includeOptions();
    }

    static interface ApplyOperation
    extends VersionSpecificOperation {
    }

    static interface DropOperation
    extends VersionSpecificOperation,
    ItemSpecificOperation {
    }

    static interface CreateOperation
    extends VersionSpecificOperation,
    ItemSpecificOperation {
    }

    static interface VersionSpecificOperation
    extends Operation {
        public MigrationVersion definedAt();
    }

    static final class DefaultRefactorOperation
    implements Operation {
        final Refactoring refactoring;

        DefaultRefactorOperation(Refactoring refactoring) {
            this.refactoring = refactoring;
        }

        @Override
        public Counters execute(OperationContext context) {
            return this.refactoring.apply(new DefaultRefactoringContext(context.sessionSupplier, context.version));
        }
    }
}

