/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.catalog.Index;
import ac.simons.neo4j.migrations.core.refactorings.AddSurrogateKey;
import ac.simons.neo4j.migrations.core.refactorings.CustomizableRefactoring;
import ac.simons.neo4j.migrations.core.refactorings.Merge;
import ac.simons.neo4j.migrations.core.refactorings.MigrateBTreeIndexes;
import ac.simons.neo4j.migrations.core.refactorings.Normalize;
import ac.simons.neo4j.migrations.core.refactorings.Refactoring;
import ac.simons.neo4j.migrations.core.refactorings.Rename;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class CatalogBasedRefactorings {
    static Refactoring fromNode(Node node) {
        String type = Optional.ofNullable(node.getAttributes().getNamedItem("type")).map(Node::getNodeValue).orElse("");
        if (type.equals("merge.nodes")) {
            return CatalogBasedRefactorings.createMerge(node, type);
        }
        if (type.equals("migrate.createFutureIndexes")) {
            return CatalogBasedRefactorings.createMigrateBtreeIndexes(node, false);
        }
        if (type.equals("migrate.replaceBTreeIndexes")) {
            return CatalogBasedRefactorings.createMigrateBtreeIndexes(node, true);
        }
        if (type.startsWith("rename.")) {
            return CatalogBasedRefactorings.createRename(node, type);
        }
        if (type.equals("normalize.asBoolean")) {
            return CatalogBasedRefactorings.createNormalizeAsBoolean(node, type);
        }
        if (type.startsWith("addSurrogateKeyTo.")) {
            return CatalogBasedRefactorings.addSurrogateKey(node, type);
        }
        throw CatalogBasedRefactorings.createException(node, type, null);
    }

    private static AddSurrogateKey addSurrogateKey(Node node, String type) {
        String op = type.split("\\.")[1];
        NodeList parameterList = CatalogBasedRefactorings.findParameterList(node).orElseThrow(() -> CatalogBasedRefactorings.createException(node, type, "The addSurrogateKey refactoring requires several parameters"));
        Optional<String> optionalCustomQuery = CatalogBasedRefactorings.findParameter(node, "customQuery", parameterList);
        AtomicReference<AddSurrogateKey> refactoring = new AtomicReference<AddSurrogateKey>();
        if ("nodes".equals(op)) {
            CatalogBasedRefactorings.findParameterValues(parameterList, "labels").filter(Predicate.not(List::isEmpty)).ifPresentOrElse(labels -> refactoring.set(AddSurrogateKey.toNodes((String)labels.get(0), (String[])labels.subList(1, labels.size()).toArray(String[]::new))), () -> {
                if (!optionalCustomQuery.isPresent()) {
                    throw CatalogBasedRefactorings.createException(node, type, "No labels specified");
                }
                refactoring.set(AddSurrogateKey.toNodesMatching(((String)optionalCustomQuery.get()).trim()));
            });
        } else if ("relationships".equals(op)) {
            CatalogBasedRefactorings.findParameter(node, "type", parameterList).ifPresentOrElse(relationshipType -> refactoring.set(AddSurrogateKey.toRelationships(relationshipType)), () -> {
                if (!optionalCustomQuery.isPresent()) {
                    throw CatalogBasedRefactorings.createException(node, type, "No `type` parameter");
                }
                refactoring.set(AddSurrogateKey.toRelationshipsMatching(((String)optionalCustomQuery.get()).trim()));
            });
        } else {
            throw CatalogBasedRefactorings.createException(node, type, String.format("`%s` is not a valid rename operation", op));
        }
        refactoring.set(CatalogBasedRefactorings.findParameter(node, "property", parameterList).map(p -> ((AddSurrogateKey)refactoring.get()).withProperty(p.trim())).orElse((AddSurrogateKey)refactoring.get()));
        refactoring.set(CatalogBasedRefactorings.findParameter(node, "generatorFunction", parameterList).map(p -> ((AddSurrogateKey)refactoring.get()).withGeneratorFunction(p.trim())).orElse((AddSurrogateKey)refactoring.get()));
        return CatalogBasedRefactorings.customize((AddSurrogateKey)refactoring.get(), node, type, parameterList);
    }

    private static Refactoring createMigrateBtreeIndexes(Node node, boolean drop) {
        MigrateBTreeIndexes migrateBTreeIndexes;
        Optional<NodeList> optionalParameters = CatalogBasedRefactorings.findParameterList(node);
        if (drop) {
            migrateBTreeIndexes = MigrateBTreeIndexes.replaceBTreeIndexes();
        } else {
            String suffix = optionalParameters.flatMap(parameters -> CatalogBasedRefactorings.findParameter(node, "suffix", parameters)).orElse(null);
            migrateBTreeIndexes = MigrateBTreeIndexes.createFutureIndexes(suffix);
        }
        List<String> excludes = optionalParameters.flatMap(parameters -> CatalogBasedRefactorings.findParameterValues(parameters, "excludes")).orElse(Collections.emptyList());
        List<String> includes = optionalParameters.flatMap(parameters -> CatalogBasedRefactorings.findParameterValues(parameters, "includes")).orElse(Collections.emptyList());
        Map<String, Index.Type> typeMappings = optionalParameters.flatMap(parameters -> CatalogBasedRefactorings.findParameterNode(parameters, "typeMapping")).map(typeMapping -> CatalogBasedRefactorings.findChildNodes(typeMapping, "mapping")).map(mappings -> mappings.stream().collect(Collectors.toMap(mapping -> CatalogBasedRefactorings.findChildNode(mapping, "name").map(Node::getTextContent).map(String::trim).orElseThrow(() -> new IllegalArgumentException("Index name is required when customizing type mappings")), mapping -> CatalogBasedRefactorings.findChildNode(mapping, "type").map(Node::getTextContent).map(String::trim).map(Index.Type::valueOf).orElseThrow(() -> new IllegalArgumentException("Type is required when customizing type mappings"))))).orElse(Collections.emptyMap());
        return migrateBTreeIndexes.withExcludes(excludes).withIncludes(includes).withTypeMapping(typeMappings);
    }

    private static Normalize createNormalizeAsBoolean(Node node, String type) {
        NodeList parameterList = CatalogBasedRefactorings.findParameterList(node).orElseThrow(() -> CatalogBasedRefactorings.createException(node, type, "The normalizeAsBoolean refactoring requires `property`, `trueValues` and `falseValues` parameters"));
        String property = CatalogBasedRefactorings.findParameter(node, "property", parameterList).orElseThrow(() -> CatalogBasedRefactorings.createException(node, type, "No `property` parameter"));
        Collection rawTrueValues = CatalogBasedRefactorings.findParameterValues(parameterList, "trueValues").orElseThrow(() -> CatalogBasedRefactorings.createException(node, type, "No `trueValues` parameter"));
        Collection rawFalseValues = CatalogBasedRefactorings.findParameterValues(parameterList, "falseValues").orElseThrow(() -> CatalogBasedRefactorings.createException(node, type, "No `falseValues` parameter"));
        Function<String, Object> mapToType = value -> {
            try {
                if (value == null || "null".equals(value)) {
                    return null;
                }
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                return value;
            }
        };
        List<Object> trueValues = rawTrueValues.stream().map(mapToType).toList();
        List<Object> falseValues = rawFalseValues.stream().map(mapToType).toList();
        Normalize normalize = Normalize.asBoolean(property, trueValues, falseValues);
        return CatalogBasedRefactorings.customize(normalize, node, type, parameterList);
    }

    private static <T extends CustomizableRefactoring<T>> T customize(T refactoring, Node node, String type, NodeList parameterList) {
        Optional<String> customQuery;
        Optional<String> batchSize = CatalogBasedRefactorings.findParameter(node, "batchSize", parameterList);
        T result = refactoring;
        if (batchSize.isPresent()) {
            try {
                result = result.inBatchesOf(Integer.parseInt(batchSize.get()));
            }
            catch (NumberFormatException nfe) {
                throw CatalogBasedRefactorings.createException(node, type, "Invalid value `" + batchSize.get() + "` for parameter `batchSize`", nfe);
            }
        }
        if ((customQuery = CatalogBasedRefactorings.findParameter(node, "customQuery", parameterList)).isPresent()) {
            result = result.withCustomQuery(customQuery.get());
        }
        return result;
    }

    private static Merge createMerge(Node node, String type) {
        String sourceQuery = CatalogBasedRefactorings.findParameter(node, "sourceQuery").orElseThrow(() -> CatalogBasedRefactorings.createException(node, type, "No source query"));
        List<Merge.PropertyMergePolicy> mergePolicies = CatalogBasedRefactorings.findAllParameters(node, "mergePolicy").stream().map(p -> {
            String pattern = null;
            Merge.PropertyMergePolicy.Strategy strategy = null;
            for (int i = 0; i < p.getChildNodes().getLength(); ++i) {
                Node item = p.getChildNodes().item(i);
                if ("pattern".equals(item.getNodeName())) {
                    pattern = item.getTextContent().trim();
                    continue;
                }
                if (!"strategy".equals(item.getNodeName())) continue;
                strategy = Merge.PropertyMergePolicy.Strategy.valueOf(item.getTextContent().trim());
            }
            if (pattern == null || strategy == null) {
                return null;
            }
            return Merge.PropertyMergePolicy.of(pattern, strategy);
        }).filter(Objects::nonNull).toList();
        return Merge.nodes(sourceQuery, mergePolicies);
    }

    private static Refactoring createRename(Node node, String type) {
        Rename rename;
        String op = type.split("\\.")[1];
        NodeList parameterList = CatalogBasedRefactorings.findParameterList(node).orElseThrow(() -> CatalogBasedRefactorings.createException(node, type, "The rename refactoring requires `from` and `to` parameters"));
        String from = CatalogBasedRefactorings.findParameter(node, "from", parameterList).orElseThrow(() -> CatalogBasedRefactorings.createException(node, type, "No `from` parameter"));
        String to = CatalogBasedRefactorings.findParameter(node, "to", parameterList).orElseThrow(() -> CatalogBasedRefactorings.createException(node, type, "No `to` parameter"));
        if ("type".equals(op)) {
            rename = Rename.type(from, to);
        } else if ("label".equals(op)) {
            rename = Rename.label(from, to);
        } else if ("nodeProperty".equals(op)) {
            rename = Rename.nodeProperty(from, to);
        } else if ("relationshipProperty".equals(op)) {
            rename = Rename.relationshipProperty(from, to);
        } else {
            throw CatalogBasedRefactorings.createException(node, type, String.format("`%s` is not a valid rename operation", op));
        }
        return CatalogBasedRefactorings.customize(rename, node, type, parameterList);
    }

    private static IllegalArgumentException createException(Node node, String type, String optionalMessage) {
        return CatalogBasedRefactorings.createException(node, type, optionalMessage, null);
    }

    private static IllegalArgumentException createException(Node node, String type, String optionalMessage, Exception cause) {
        String typeAsAttribute = type == null || type.trim().isEmpty() ? "" : String.format(" type=\"%s\"", type.trim());
        Object suffix = optionalMessage == null ? "" : ": " + optionalMessage;
        return new IllegalArgumentException(String.format("Cannot parse <%s%s /> into a supported refactoring%s", node.getNodeName(), typeAsAttribute, suffix), cause);
    }

    private static Optional<NodeList> findParameterList(Node refactoring) {
        NodeList parameters = null;
        NodeList refactoringChildNodes = refactoring.getChildNodes();
        for (int i = 0; i < refactoringChildNodes.getLength(); ++i) {
            if (!"parameters".equals(refactoringChildNodes.item(i).getNodeName())) continue;
            parameters = refactoringChildNodes.item(i).getChildNodes();
            break;
        }
        return Optional.ofNullable(parameters);
    }

    private static Optional<String> findParameter(Node refactoring, String name) {
        return CatalogBasedRefactorings.findParameter(refactoring, name, null);
    }

    private static Optional<Node> findParameterNode(NodeList parameters, String name) {
        for (int i = 0; i < parameters.getLength(); ++i) {
            Node parameterName;
            Node parameter = parameters.item(i);
            if (!"parameter".equals(parameter.getNodeName()) || !parameter.hasAttributes() || (parameterName = parameter.getAttributes().getNamedItem("name")) == null || !name.equals(parameterName.getNodeValue())) continue;
            return Optional.of(parameter);
        }
        return Optional.empty();
    }

    private static Optional<String> findParameter(Node refactoring, String name, NodeList optionalParameters) {
        return Optional.ofNullable(optionalParameters).or(() -> CatalogBasedRefactorings.findParameterList(refactoring)).flatMap(parameters -> CatalogBasedRefactorings.findParameterNode(parameters, name)).map(Node::getTextContent).map(String::trim).filter(v -> !v.isEmpty());
    }

    private static List<Node> findAllParameters(Node refactoring, String name) {
        return CatalogBasedRefactorings.findParameterList(refactoring).map(parameters -> {
            ArrayList<Node> result = new ArrayList<Node>();
            for (int i = 0; i < parameters.getLength(); ++i) {
                Node parameterName;
                Node parameter = parameters.item(i);
                if (!"parameter".equals(parameter.getNodeName()) || !parameter.hasAttributes() || (parameterName = parameter.getAttributes().getNamedItem("name")) == null || !name.equals(parameterName.getNodeValue())) continue;
                result.add(parameter);
            }
            return result;
        }).orElseGet(Collections::emptyList);
    }

    private static Optional<List<String>> findParameterValues(NodeList parametersNodeList, String parameterNameToFind) {
        if (parametersNodeList == null) {
            return Optional.empty();
        }
        Function<Node, List> aggregateValues = parameterNode -> {
            ArrayList<String> values = new ArrayList<String>();
            NodeList childNodes = parameterNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (!"value".equals(childNode.getNodeName())) continue;
                if (!childNode.hasChildNodes()) {
                    values.add(null);
                    continue;
                }
                values.add(childNode.getTextContent());
            }
            return values;
        };
        return CatalogBasedRefactorings.findParameterNode(parametersNodeList, parameterNameToFind).map(aggregateValues);
    }

    private static Optional<Node> findChildNode(Node node, String childNodeName) {
        NodeList childNodes = node.getChildNodes();
        Optional<Node> result = Optional.empty();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!childNodeName.equals(childNode.getNodeName())) continue;
            if (result.isPresent()) {
                throw new IllegalArgumentException("Duplicate child node `" + childNodeName + "`");
            }
            result = Optional.of(childNode);
        }
        return result;
    }

    private static List<Node> findChildNodes(Node node, String childNodeName) {
        NodeList childNodes = node.getChildNodes();
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!childNodeName.equals(childNode.getNodeName())) continue;
            result.add(childNode);
        }
        return result;
    }

    private CatalogBasedRefactorings() {
    }
}

