/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.DefaultMigrationChain;
import ac.simons.neo4j.migrations.core.DefaultMigrationChainElement;
import ac.simons.neo4j.migrations.core.Migration;
import ac.simons.neo4j.migrations.core.MigrationChain;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import ac.simons.neo4j.migrations.core.MigrationWithPreconditions;
import ac.simons.neo4j.migrations.core.Migrations;
import ac.simons.neo4j.migrations.core.MigrationsException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Value;

final class ChainBuilder {
    private final boolean alwaysVerify;

    ChainBuilder() {
        this(false);
    }

    ChainBuilder(boolean alwaysVerify) {
        this.alwaysVerify = alwaysVerify;
    }

    MigrationChain buildChain(MigrationContext context, List<Migration> discoveredMigrations) {
        return this.buildChain(context, discoveredMigrations, false, MigrationChain.ChainBuilderMode.COMPARE);
    }

    MigrationChain buildChain(MigrationContext context, List<Migration> discoveredMigrations, boolean detailedCauses, MigrationChain.ChainBuilderMode mode) {
        Map<MigrationVersion, MigrationChain.Element> elements = this.buildChain0(context, discoveredMigrations, detailedCauses, mode);
        return new DefaultMigrationChain(context.getConnectionDetails(), elements);
    }

    private Map<MigrationVersion, MigrationChain.Element> buildChain0(MigrationContext context, List<Migration> discoveredMigrations, boolean detailedCauses, MigrationChain.ChainBuilderMode mode) {
        Map appliedMigrations;
        Map<Object, Object> map = appliedMigrations = mode == MigrationChain.ChainBuilderMode.LOCAL ? Collections.emptyMap() : this.getChainOfAppliedMigrations(context);
        if (mode == MigrationChain.ChainBuilderMode.REMOTE) {
            return Collections.unmodifiableMap(appliedMigrations);
        }
        String incompleteMigrationsMessage = "More migrations have been applied to the database than locally resolved.";
        LinkedHashMap<MigrationVersion, MigrationChain.Element> fullMigrationChain = new LinkedHashMap<MigrationVersion, MigrationChain.Element>(discoveredMigrations.size() + appliedMigrations.size());
        int i = 0;
        for (Map.Entry entry : appliedMigrations.entrySet()) {
            Migration newMigration;
            MigrationVersion expectedVersion = (MigrationVersion)entry.getKey();
            Optional<String> expectedChecksum = ((MigrationChain.Element)entry.getValue()).getChecksum();
            try {
                newMigration = discoveredMigrations.get(i);
            }
            catch (IndexOutOfBoundsException e) {
                if (detailedCauses) {
                    throw new MigrationsException("More migrations have been applied to the database than locally resolved.", e);
                }
                throw new MigrationsException("More migrations have been applied to the database than locally resolved.");
            }
            if (!newMigration.getVersion().equals(expectedVersion)) {
                if (this.getNumberOfAppliedMigrations(context) > discoveredMigrations.size()) {
                    throw new MigrationsException("More migrations have been applied to the database than locally resolved.", new IndexOutOfBoundsException());
                }
                throw new MigrationsException("Unexpected migration at index " + i + ": " + Migrations.toString(newMigration) + ".");
            }
            if (newMigration.isRepeatable() != expectedVersion.isRepeatable()) {
                throw new MigrationsException("State of " + Migrations.toString(newMigration) + " changed from " + (expectedVersion.isRepeatable() ? "repeatable to non-repeatable" : "non-repeatable to repeatable"));
            }
            if ((context.getConfig().isValidateOnMigrate() || this.alwaysVerify) && !ChainBuilder.matches(expectedChecksum, newMigration) && !expectedVersion.isRepeatable()) {
                throw new MigrationsException("Checksum of " + Migrations.toString(newMigration) + " changed!");
            }
            fullMigrationChain.put(expectedVersion, (MigrationChain.Element)entry.getValue());
            ++i;
        }
        while (i < discoveredMigrations.size()) {
            Migration pendingMigration = discoveredMigrations.get(i++);
            MigrationChain.Element element = DefaultMigrationChainElement.pendingElement(pendingMigration);
            fullMigrationChain.put(pendingMigration.getVersion(), element);
        }
        return Collections.unmodifiableMap(fullMigrationChain);
    }

    static boolean matches(Optional<String> expectedChecksum, Migration newMigration) {
        if (expectedChecksum.equals(newMigration.getChecksum())) {
            return true;
        }
        if (!(newMigration instanceof MigrationWithPreconditions) || !expectedChecksum.isPresent()) {
            return false;
        }
        return ((MigrationWithPreconditions)newMigration).getAlternativeChecksums().contains(expectedChecksum.get());
    }

    private int getNumberOfAppliedMigrations(MigrationContext context) {
        String query = "MATCH (n:__Neo4jMigration)\nWHERE n.version <> 'BASELINE' AND coalesce(n.migrationTarget,'<default>') = coalesce($migrationTarget,'<default>')\nRETURN count(n)\n";
        try (Session session = context.getSchemaSession();){
            int n = (Integer)session.executeRead(tx -> {
                String migrationTarget = context.getConfig().getMigrationTargetIn(context).orElse(null);
                return tx.run(query, Collections.singletonMap("migrationTarget", migrationTarget)).single().get(0).asInt();
            });
            return n;
        }
    }

    private Map<MigrationVersion, MigrationChain.Element> getChainOfAppliedMigrations(MigrationContext context) {
        String query = "MATCH p=(b:__Neo4jMigration {version:'BASELINE'}) - [r:MIGRATED_TO*] -> (l:__Neo4jMigration)\nWHERE coalesce(b.migrationTarget,'<default>') = coalesce($migrationTarget,'<default>') AND NOT (l)-[:MIGRATED_TO]->(:__Neo4jMigration)\nWITH p\nOPTIONAL MATCH () - [r:REPEATED] -> ()\nWITH p, r order by r.at DESC\nRETURN p, collect(r) AS repetitions\n";
        try (Session session = context.getSchemaSession();){
            Map map = (Map)session.executeRead(tx -> {
                LinkedHashMap chain = new LinkedHashMap();
                String migrationTarget = context.getConfig().getMigrationTargetIn(context).orElse(null);
                Result result = tx.run(query, Collections.singletonMap("migrationTarget", migrationTarget));
                if (result.hasNext()) {
                    Record row = result.single();
                    List repetitions = row.get("repetitions").asList(Value::asRelationship);
                    row.get("p").asPath().forEach(segment -> {
                        MigrationChain.Element chainElement = DefaultMigrationChainElement.appliedElement(segment, repetitions);
                        chain.put(MigrationVersion.withValue(chainElement.getVersion(), segment.end().get("repeatable").asBoolean(false)), chainElement);
                    });
                }
                return chain;
            });
            return map;
        }
    }
}

