/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.DatabaseOperationResult;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class CleanResult
implements DatabaseOperationResult {
    private final String affectedDatabase;
    private final List<String> chainsDeleted;
    private final long nodesDeleted;
    private final long relationshipsDeleted;
    private final long constraintsRemoved;
    private final long indexesRemoved;

    CleanResult(Optional<String> affectedDatabase, List<String> chainsDeleted, long nodesDeleted, long relationshipsDeleted, long constraintsRemoved, long indexesRemoved) {
        this.affectedDatabase = affectedDatabase.orElse(null);
        this.chainsDeleted = List.copyOf(chainsDeleted);
        this.nodesDeleted = nodesDeleted;
        this.relationshipsDeleted = relationshipsDeleted;
        this.constraintsRemoved = constraintsRemoved;
        this.indexesRemoved = indexesRemoved;
    }

    @Override
    public Optional<String> getAffectedDatabase() {
        return Optional.ofNullable(this.affectedDatabase);
    }

    public List<String> getChainsDeleted() {
        return this.chainsDeleted;
    }

    public long getNodesDeleted() {
        return this.nodesDeleted;
    }

    public long getRelationshipsDeleted() {
        return this.relationshipsDeleted;
    }

    public long getConstraintsRemoved() {
        return this.constraintsRemoved;
    }

    public long getIndexesRemoved() {
        return this.indexesRemoved;
    }

    @Override
    public String prettyPrint() {
        String prefix = "chain" + (this.getChainsDeleted().size() > 1 ? "s " : " ");
        return String.format("Deleted %s (%d nodes and %d relationships in total) and %d constraints from %s.", this.getChainsDeleted().isEmpty() ? "no chains" : this.getChainsDeleted().stream().collect(Collectors.joining(", ", prefix, "")), this.getNodesDeleted(), this.getRelationshipsDeleted(), this.getConstraintsRemoved(), this.getAffectedDatabase().map(v -> "`" + v + "`").orElse("the default database"));
    }
}

