/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.DefaultCypherResource;
import ac.simons.neo4j.migrations.core.Defaults;
import ac.simons.neo4j.migrations.core.ResourceContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CypherResource {
    public static CypherResource of(URL url) {
        return CypherResource.of(url, false);
    }

    public static CypherResource of(URL url, boolean autocrlf) {
        return new DefaultCypherResource(ResourceContext.generateIdentifierOf(url), autocrlf, () -> {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static WithContent withContent(String content) {
        return identifier -> new DefaultCypherResource(identifier, false, () -> new ByteArrayInputStream(content.getBytes(Defaults.CYPHER_SCRIPT_ENCODING)));
    }

    public String getIdentifier();

    public String getChecksum();

    public List<String> getExecutableStatements();

    public List<String> getSingleLineComments();

    public static interface WithContent {
        public CypherResource identifiedBy(String var1);
    }
}

