/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.Migrations;
import ac.simons.neo4j.migrations.core.MigrationsLock;
import ac.simons.neo4j.migrations.core.Neo4jVersion;
import ac.simons.neo4j.migrations.core.catalog.Catalog;
import ac.simons.neo4j.migrations.core.catalog.CatalogItem;
import ac.simons.neo4j.migrations.core.catalog.Constraint;
import ac.simons.neo4j.migrations.core.catalog.Index;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.driver.Record;
import org.neo4j.driver.SimpleQueryRunner;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.MapAccessor;

final class DatabaseCatalog
implements Catalog {
    private final Collection<CatalogItem<?>> items;

    static Catalog full(Neo4jVersion version, SimpleQueryRunner queryRunner) {
        return DatabaseCatalog.of(version, queryRunner, true, false);
    }

    static Catalog of(Neo4jVersion version, SimpleQueryRunner queryRunner, boolean readOptions) {
        return DatabaseCatalog.of(version, queryRunner, readOptions, true);
    }

    private static Catalog of(Neo4jVersion version, SimpleQueryRunner queryRunner, boolean readOptions, boolean filterInternalConstraints) {
        LinkedHashSet items = new LinkedHashSet();
        Function<Record, MapAccessor> mapAccessorMapper = r -> readOptions ? r : new FilteredMapAccessor((MapAccessor)r, Collections.singleton("options"));
        Predicate<Constraint> internalConstraints = c -> true;
        if (filterInternalConstraints) {
            internalConstraints = constraint -> Arrays.stream(MigrationsLock.REQUIRED_CONSTRAINTS).noneMatch(constraint::isEquivalentTo);
            internalConstraints = internalConstraints.and(c -> !Migrations.UNIQUE_VERSION.isEquivalentTo((CatalogItem<?>)c));
        }
        queryRunner.run(version.getShowConstraints()).stream().map(mapAccessorMapper).map(Constraint::parse).filter(internalConstraints).forEach(items::add);
        queryRunner.run(version.getShowIndexes()).stream().map(mapAccessorMapper).map(Index::parse).filter(index -> index.getType() != Index.Type.LOOKUP && index.getType() != Index.Type.CONSTRAINT_BACKING_INDEX).forEach(items::add);
        return new DatabaseCatalog(items);
    }

    private DatabaseCatalog(Set<CatalogItem<?>> items) {
        this.items = items;
    }

    @Override
    public Collection<CatalogItem<?>> getItems() {
        return this.items;
    }

    private static final class FilteredMapAccessor
    implements MapAccessor {
        private final MapAccessor delegate;
        private final Set<String> filteredKeys;

        FilteredMapAccessor(MapAccessor delegate, Set<String> filter) {
            this.delegate = delegate;
            this.filteredKeys = new HashSet<String>();
            this.delegate.keys().forEach(this.filteredKeys::add);
            this.filteredKeys.removeAll(filter);
        }

        public Iterable<String> keys() {
            return this.filteredKeys;
        }

        public boolean containsKey(String key) {
            return this.filteredKeys.contains(key);
        }

        public Value get(String key) {
            return this.filteredKeys.contains(key) ? this.delegate.get(key) : Values.NULL;
        }

        public int size() {
            throw new UnsupportedOperationException();
        }

        public Iterable<Value> values() {
            throw new UnsupportedOperationException();
        }

        public <T> Iterable<T> values(Function<Value, T> mapFunction) {
            throw new UnsupportedOperationException();
        }

        public Map<String, Object> asMap() {
            throw new UnsupportedOperationException();
        }

        public <T> Map<String, T> asMap(Function<Value, T> mapFunction) {
            throw new UnsupportedOperationException();
        }
    }
}

