/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.MigrationVersion;
import ac.simons.neo4j.migrations.core.MigrationsException;
import ac.simons.neo4j.migrations.core.VersionedCatalog;
import ac.simons.neo4j.migrations.core.WriteableCatalog;
import ac.simons.neo4j.migrations.core.catalog.Catalog;
import ac.simons.neo4j.migrations.core.catalog.CatalogItem;
import ac.simons.neo4j.migrations.core.catalog.Name;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class DefaultCatalog
implements WriteableCatalog,
VersionedCatalog {
    private final Map<Name, NavigableMap<MigrationVersion, CatalogItem<?>>> items;
    private final ReentrantReadWriteLock locks = new ReentrantReadWriteLock();
    private final NavigableMap<MigrationVersion, VersionedCatalog> oldVersions = new TreeMap<MigrationVersion, VersionedCatalog>(new MigrationVersion.VersionComparator());

    DefaultCatalog() {
        this(new HashMap());
    }

    private DefaultCatalog(Map<Name, NavigableMap<MigrationVersion, CatalogItem<?>>> items) {
        this.items = items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAll(MigrationVersion version, Catalog other, boolean reset) {
        ReentrantReadWriteLock.WriteLock lock = this.locks.writeLock();
        try {
            lock.lock();
            if (reset) {
                if (this.oldVersions.containsKey(version)) {
                    throw new IllegalArgumentException("Catalog has been already reset at version " + version.getValue());
                }
                if (this.containsVersion(version)) {
                    throw new IllegalArgumentException("Version " + version.getValue() + " has already been used in this catalog.");
                }
                this.oldVersions.put(version, new DefaultCatalog(new HashMap(this.items)));
                this.items.clear();
            }
            for (CatalogItem<?> item : other.getItems()) {
                NavigableMap versionedItems = this.items.computeIfAbsent(item.getName(), k -> new TreeMap(new MigrationVersion.VersionComparator()));
                if (versionedItems.containsKey(version)) {
                    throw new MigrationsException(String.format("A constraint with the name '%s' has already been added to this catalog under the version %s.", item.getName().getValue(), version.getValue()));
                }
                versionedItems.put(version, item);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private boolean containsVersion(MigrationVersion version) {
        return this.items.entrySet().stream().flatMap(v -> ((NavigableMap)v.getValue()).keySet().stream()).anyMatch(version::equals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withReadLockGet(Supplier<T> s) {
        ReentrantReadWriteLock.ReadLock lock = this.locks.readLock();
        try {
            lock.lock();
            T t = s.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Collection<CatalogItem<?>> getItems() {
        return this.withReadLockGet(() -> this.items.values().stream().map(NavigableMap::lastEntry).map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public Collection<CatalogItem<?>> getItemsPriorTo(MigrationVersion version) {
        return this.withReadLockGet(() -> {
            Map.Entry<MigrationVersion, VersionedCatalog> oldEntry = this.oldVersions.ceilingEntry(version);
            if (oldEntry != null) {
                return oldEntry.getValue().getItemsPriorTo(version);
            }
            return this.items.values().stream().map(m -> Optional.ofNullable(m.lowerEntry(version)).map(Map.Entry::getValue)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        });
    }

    @Override
    public Optional<CatalogItem<?>> getItemPriorTo(Name name, MigrationVersion version) {
        return this.withReadLockGet(() -> {
            Map.Entry<MigrationVersion, VersionedCatalog> oldEntry = this.oldVersions.ceilingEntry(version);
            if (oldEntry != null) {
                return oldEntry.getValue().getItemPriorTo(name, version);
            }
            return Optional.ofNullable(this.items.get(name)).map(m -> m.lowerEntry(version)).map(Map.Entry::getValue);
        });
    }

    @Override
    public Collection<CatalogItem<?>> getItems(MigrationVersion version) {
        return this.withReadLockGet(() -> {
            Map.Entry<MigrationVersion, VersionedCatalog> oldEntry = this.oldVersions.higherEntry(version);
            if (oldEntry != null) {
                return oldEntry.getValue().getItems(version);
            }
            return this.items.values().stream().map(m -> Optional.ofNullable(m.floorEntry(version)).map(Map.Entry::getValue)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        });
    }

    @Override
    public Optional<CatalogItem<?>> getItem(Name name, MigrationVersion version) {
        return this.withReadLockGet(() -> {
            Map.Entry<MigrationVersion, VersionedCatalog> oldEntry = this.oldVersions.higherEntry(version);
            if (oldEntry != null) {
                return oldEntry.getValue().getItem(name, version);
            }
            return Optional.ofNullable(this.items.get(name)).map(m -> m.floorEntry(version)).map(Map.Entry::getValue);
        });
    }
}

