/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.ConnectionDetails;
import ac.simons.neo4j.migrations.core.internal.Strings;
import java.util.Optional;

final class DefaultConnectionDetails
implements ConnectionDetails {
    private final String serverAddress;
    private final String serverVersion;
    private final String edition;
    private final String username;
    private final String databaseName;
    private final String schemaDatabaseName;

    DefaultConnectionDetails(String serverAddress, String serverVersion, String edition, String username, String databaseName, String schemaDatabaseName) {
        this.serverAddress = serverAddress;
        this.serverVersion = serverVersion;
        this.edition = Strings.capitalize(edition);
        this.username = username;
        this.databaseName = databaseName;
        this.schemaDatabaseName = schemaDatabaseName;
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public String getServerEdition() {
        return this.edition;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public Optional<String> getOptionalDatabaseName() {
        return Optional.ofNullable(this.databaseName);
    }

    @Override
    public Optional<String> getOptionalSchemaDatabaseName() {
        return Optional.ofNullable(this.schemaDatabaseName);
    }
}

