/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.ConnectionDetails;
import ac.simons.neo4j.migrations.core.MigrationChain;
import ac.simons.neo4j.migrations.core.MigrationState;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

final class DefaultMigrationChain
implements MigrationChain {
    private final ConnectionDetails connectionDetailsDelegate;
    private final Map<MigrationVersion, MigrationChain.Element> elements;

    DefaultMigrationChain(ConnectionDetails connectionDetailsDelegate, Map<MigrationVersion, MigrationChain.Element> elements) {
        this.connectionDetailsDelegate = connectionDetailsDelegate;
        this.elements = elements;
    }

    @Override
    public String getServerAddress() {
        return this.connectionDetailsDelegate.getServerAddress();
    }

    @Override
    public String getServerVersion() {
        return this.connectionDetailsDelegate.getServerVersion();
    }

    @Override
    public String getServerEdition() {
        return this.connectionDetailsDelegate.getServerEdition();
    }

    @Override
    public String getUsername() {
        return this.connectionDetailsDelegate.getUsername();
    }

    @Override
    public Optional<String> getOptionalDatabaseName() {
        return this.connectionDetailsDelegate.getOptionalDatabaseName();
    }

    @Override
    public Optional<String> getOptionalSchemaDatabaseName() {
        return this.connectionDetailsDelegate.getOptionalSchemaDatabaseName();
    }

    @Override
    public boolean isApplied(String version) {
        MigrationChain.Element element = this.elements.get(MigrationVersion.withValue(version));
        return element != null && element.getState() == MigrationState.APPLIED;
    }

    @Override
    public Collection<MigrationChain.Element> getElements() {
        return this.elements.values();
    }

    @Override
    public Optional<MigrationVersion> getLastAppliedVersion() {
        Iterator<MigrationVersion> it = this.elements.keySet().iterator();
        MigrationVersion version = null;
        while (it.hasNext()) {
            version = it.next();
        }
        return Optional.ofNullable(version);
    }
}

