/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.AbstractRepairmentResult;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import java.util.Optional;

public final class DeleteResult
extends AbstractRepairmentResult {
    private final MigrationVersion version;

    DeleteResult(String affectedDatabase, long nodesDeleted, long nodesCreated, long relationshipsDeleted, long relationshipsCreated, long propertiesSet, MigrationVersion version) {
        super(affectedDatabase, nodesDeleted, nodesCreated, relationshipsDeleted, relationshipsCreated, propertiesSet);
        this.version = version;
    }

    public boolean isDatabaseChanged() {
        return this.version != null && this.getNodesDeleted() > 0L;
    }

    public Optional<MigrationVersion> getVersion() {
        return Optional.ofNullable(this.version);
    }

    @Override
    public String prettyPrint() {
        if (!this.isDatabaseChanged()) {
            return "Database is unchanged, no version has been deleted.";
        }
        return String.format("Migration %s has been removed (deleted %d nodes and %d relationships from %s).", DeleteResult.toString(this.version), this.getNodesDeleted(), this.getRelationshipsDeleted(), this.getAffectedDatabase().map(v -> "`" + v + "`").orElse("the default database"));
    }
}

