/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.ConnectionDetails;
import ac.simons.neo4j.migrations.core.MigrationsException;
import ac.simons.neo4j.migrations.core.Neo4jCodes;
import ac.simons.neo4j.migrations.core.Neo4jEdition;
import ac.simons.neo4j.migrations.core.internal.Neo4jVersionComparator;
import java.util.Locale;
import java.util.function.Supplier;
import org.neo4j.driver.Session;
import org.neo4j.driver.TransactionContext;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.Neo4jException;

final class HBD {
    static boolean is4xSeries(ConnectionDetails connectionDetails) {
        return connectionDetails.getServerVersion() != null && connectionDetails.getServerVersion().replaceFirst("(?i)^Neo4j/", "").matches("^4\\.?.*");
    }

    static boolean is44OrHigher(ConnectionDetails connectionDetails) {
        if (connectionDetails.getServerVersion() == null) {
            return false;
        }
        Neo4jVersionComparator versionComparator = new Neo4jVersionComparator();
        return versionComparator.compare(connectionDetails.getServerVersion(), "4.4") >= 0;
    }

    static Integer silentCreateConstraint(ConnectionDetails connectionDetails, Session session, String statement, String name, Supplier<String> failureMessage) {
        Object replacement = "";
        if (HBD.is4xSeries(connectionDetails) && name != null && !name.trim().isEmpty()) {
            replacement = name.trim() + " ";
        }
        String finalStatement = statement.replace("$name ", (CharSequence)replacement);
        try {
            return (Integer)session.executeWrite(tx -> tx.run(finalStatement).consume().counters().constraintsAdded());
        }
        catch (Neo4jException e) {
            if (!Neo4jCodes.CODES_FOR_EXISTING_CONSTRAINT.contains(e.code())) {
                throw new MigrationsException(failureMessage.get(), e);
            }
            return 0;
        }
    }

    static Integer silentDropConstraint(ConnectionDetails connectionDetails, Session session, String statement, String name) {
        Object finalStatement = HBD.is4xSeries(connectionDetails) && name != null && !name.trim().isEmpty() ? "DROP CONSTRAINT " + name.trim() : statement;
        try {
            return (Integer)session.executeWrite(arg_0 -> HBD.lambda$silentDropConstraint$1((String)finalStatement, arg_0));
        }
        catch (Neo4jException e) {
            if (!"Neo.DatabaseError.Schema.ConstraintDropFailed".equals(e.code())) {
                throw new MigrationsException("Could not remove locks", e);
            }
            return 0;
        }
    }

    static boolean constraintWithNameAlreadyExists(MigrationsException e) {
        ClientException ce;
        Throwable throwable;
        return e != null && (throwable = e.getCause()) instanceof ClientException && "Neo.ClientError.Schema.ConstraintWithNameAlreadyExists".equals((ce = (ClientException)throwable).code());
    }

    static boolean constraintProbablyRequiredEnterpriseEdition(Exception rawException, ConnectionDetails connectionDetails) {
        Neo4jException e;
        if (rawException instanceof Neo4jException) {
            Neo4jException ne;
            e = ne = (Neo4jException)((Object)rawException);
        } else {
            Throwable throwable = rawException.getCause();
            if (throwable instanceof Neo4jException) {
                Neo4jException ne;
                e = ne = (Neo4jException)throwable;
            } else {
                return false;
            }
        }
        if (!"Neo.DatabaseError.Schema.ConstraintCreationFailed".equals(e.code())) {
            return false;
        }
        if (Neo4jEdition.of(connectionDetails.getServerEdition()) == Neo4jEdition.ENTERPRISE) {
            return false;
        }
        return e.getMessage().toLowerCase(Locale.ROOT).contains("constraint requires Neo4j Enterprise Edition".toLowerCase(Locale.ROOT));
    }

    private HBD() {
    }

    private static /* synthetic */ Integer lambda$silentDropConstraint$1(String finalStatement, TransactionContext tx) {
        return tx.run(finalStatement).consume().counters().constraintsRemoved();
    }
}

